package com.biz.crm.cps.business.policy.display.ladder.local.controller;

import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskDetailVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskDetailVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 13:55
 */
@Slf4j
@RestController
@RequestMapping("/v1/display/task")
@Api(tags = "陈列任务手机端详情Vo相关接口")
public class DisplayTaskDetailVoController {

  @Autowired
  private DisplayTaskDetailVoService displayTaskDetailVoService;

  @ApiOperation(value = "根据业务单号查询陈列任务详情(手机端)")
  @GetMapping("findDetailByBusinessCode")
  public Result<DisplayTaskDetailVo> findDetailByBusinessCode(@RequestParam String businessCode) {
    try {
      DisplayTaskDetailVo displayTaskDetailVo = displayTaskDetailVoService.findDetailByBusinessCode(businessCode);
      return Result.ok(displayTaskDetailVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
