package com.biz.crm.cps.business.policy.display.ladder.local.controller;

import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 陈列任务Vo相关接口
 *
 * @author HuaHongQiang
 * @date 2021/8/27 13:55
 */
@Slf4j
@RestController
@RequestMapping("/v1/display/task")
@Api(tags = "陈列任务Vo相关接口")
public class DisplayTaskVoController {

  @Autowired private DisplayTaskVoService displayTaskVoService;

  /**
   * 根据业务单号查询陈列任务
   *
   * @param businessCode
   * @return
   */
  @ApiOperation(value = "根据业务单号查询陈列任务")
  @GetMapping("findByBusinessCode")
  public Result<DisplayTaskVo> findByBusinessCode(@RequestParam String businessCode) {
    try {
      DisplayTaskVo displayTaskVo = displayTaskVoService.findByBusinessCode(businessCode);
      return Result.ok(displayTaskVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据终端code查询任务列表(手机端)
   *
   * @param taskStatus    DisplayTaskStatusNewEnum
   * @return
   */
  @ApiOperation(value = "根据终端code查询任务列表(手机端)")
  @GetMapping("findByTerminalCode")
  public Result<List<DisplayTaskVo>> findByTerminalCode(@RequestParam String taskStatus) {
    try {
      List<DisplayTaskVo> displayTaskVos =
          displayTaskVoService.findByTerminalCode(taskStatus);
      return Result.ok(displayTaskVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据业务单号查询陈列任务上传图片
   *
   * @param businessCode
   * @return
   */
  @ApiOperation(value = "根据业务单号查询陈列任务上传图片")
  @GetMapping("findPictureByBusinessCode")
  public Result<DisplayTaskVo> findPictureByBusinessCode(@RequestParam String businessCode) {
    try {
      DisplayTaskVo displayTaskVo = displayTaskVoService.findPictureByBusinessCode(businessCode);
      return Result.ok(displayTaskVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
