package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/9/27 16:29
 * 陈列政策分利任务实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayCalculateTask", description = "陈列政策分利任务实体")
@TableName("ladder_display_calculate_task")
public class DisplayCalculateTask extends TenantOpEntity {

  private static final long serialVersionUID = -1676624416115160326L;

  /**
   * 业务单号(生成陈列任务时生成)
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 任务名称(根据协议和协议划定每月陈列任务次数命名，政策进行生成)
   */
  @ApiModelProperty("任务名称")
  @TableField(value = "task_name")
  @Column(name = "task_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务名称 '")
  private String taskName;

  /**
   * 任务状态(未开始，执行中，已完成/已分利)
   */
  @ApiModelProperty("任务状态(未开始，执行中，已完成/已分利)")
  @TableField(value = "task_status")
  @Column(name = "task_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务状态(未开始，执行中，已完成/已分利) '")
  private String taskStatus;

  /**
   * 陈列政策id
   */
  @ApiModelProperty("陈列政策id")
  @TableField(value = "display_policy_id")
  @Column(name = "display_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策id '")
  private String displayPolicyId;

  /**
   * 陈列政策配置id
   */
  @ApiModelProperty("陈列政策配置id")
  @TableField(value = "display_policy_configuration_id")
  @Column(name = "display_policy_configuration_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策配置id '")
  private String displayPolicyConfigurationId;

  /**
   * 所属协议id
   */
  @ApiModelProperty("所属协议id")
  @TableField(value = "agreement_id")
  @Column(name = "agreement_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属协议id '")
  private String agreementId;

  /**
   * 所属协议名称
   */
  @ApiModelProperty("所属协议名称")
  @TableField(value = "agreement_name")
  @Column(name = "agreement_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属协议名称 '")
  private String agreementName;

  /**
   * 所属模板id
   */
  @ApiModelProperty("所属模板id")
  @TableField(value = "template_id")
  @Column(name = "template_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属模板id '")
  private String templateId;

  /**
   * 所属模板名称
   */
  @ApiModelProperty("所属模板名称")
  @TableField(value = "template_name")
  @Column(name = "template_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属模板名称 '")
  private String templateName;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 终端编码 '")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 终端名称 '")
  private String terminalName;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @TableField(value = "task_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "task_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 任务开始时间 '")
  private Date taskStartTime;

  /**
   * 任务结束时间
   */
  @ApiModelProperty("任务结束时间")
  @TableField(value = "task_end_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "task_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 任务结束时间 '")
  private Date taskEndTime;

  /**
   * 是否绑定销量目标
   */
  @ApiModelProperty("是否绑定销量目标")
  @TableField(value = "bind_sale_status")
  @Column(name = "bind_sale_status", nullable = false, length = 4, columnDefinition = "VARCHAR(4) COMMENT ' 是否绑定销量目标 '")
  private String bindSaleStatus;

  /**
   * 销量目标
   */
  @ApiModelProperty("销量目标")
  @TableField(value = "sale_target")
  @Column(name = "sale_target", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 销量目标 '")
  private BigDecimal saleTarget;

  /**
   * 任务类型(年度，半年度，季度，月度)
   */
  @ApiModelProperty("任务类型(年度，半年度，季度，月度)")
  @TableField(value = "task_type")
  @Column(name = "task_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务类型(年度，半年度，季度，月度) '")
  private String taskType;

  /**
   * 协议分利表达式列表
   */
  @ApiModelProperty("协议分利表达式列表")
  @TableField(exist = false)
  private List<DisplayTaskExpression> displayTaskExpressionList;

  /**
   * 陈列次数
   */
  @ApiModelProperty("陈列次数")
  @TableField(value = "display_times")
  private BigDecimal displayTimes;

  /**
   * 陈列完成次数
   */
  @ApiModelProperty("陈列完成次数")
  @TableField(value = "display_finish_times")
  private BigDecimal displayFinishTimes;

  /**
   * 陈列完成率
   */
  @ApiModelProperty("陈列完成率")
  @TableField(value = "display_finish_rate")
  private BigDecimal displayFinishRate;

  /**
   * 实际销量
   */
  @ApiModelProperty("实际销量")
  @TableField(value = "sale_actual")
  private BigDecimal saleActual;

  /**
   * 扫码完成率
   */
  @ApiModelProperty("扫码完成率")
  @TableField(value = "scan_rate")
  private BigDecimal scanRate;

  /**
   * 分利状态
   */
  @ApiModelProperty("分利状态 已分利:1、未分利:0")
  @TableField(value = "share_profit_status")
  private String shareProfitStatus;

  /**
   * 陈列类型
   */
  @ApiModelProperty("陈列类型")
  @TableField(value = "display_type")
  private String displayType;
}
