package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 陈列任务与陈列明细任务关联关系表
 *
 * @author sunx
 * @date 2021/9/27 16:29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayCalculateTaskRelateTask", description = "陈列任务与陈列明细任务关联关系实体")
@TableName("ladder_display_calculate_task_relate_task")
public class DisplayCalculateTaskRelateTask implements Serializable {
  private static final long serialVersionUID = 5461833517445102814L;

  @TableId(type = IdType.ASSIGN_UUID)
  private String id;

  /** 陈列任务业务编码 */
  @ApiModelProperty(name = "calculateTaskCode", value = "陈列任务业务编码")
  @TableField(value = "calculate_task_code")
  private String calculateTaskCode;

  /** 陈列明细任务业务编码 */
  @ApiModelProperty(name = "taskCode", value = "陈列明细任务业务编码")
  @TableField(value = "task_code")
  private String taskCode;

  /**
   * 租户编号 @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT
   * '租户编号'")
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号")
  @TableField(value = "tenant_code")
  private String tenantCode;
}
