package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <pre>
 *                            ｜n产品维度
 *                ｜n 配置-----｜1奖励规则
 * 陈列政策实例----｜1 销量目标
 *                ｜n 上传规则
 *</pre>
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayPolicy", description = "陈列政策实例")
@TableName("ladder_display_policy")
public class DisplayPolicy extends TenantOpEntity {

  private static final long serialVersionUID = 4228363826820555441L;
  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议模板编码 '")
  private String templateCode;

  /**
   * 是否绑定销量目标
   */
  @ApiModelProperty("是否绑定销量目标")
  @TableField(value = "bind_sale_status")
  @Column(name = "bind_sale_status", nullable = false, length = 4, columnDefinition = "VARCHAR(4) COMMENT ' 是否绑定销量目标 '")
  private String bindSaleStatus;

  /**
   * 销量目标
   *
   * @OneToOne(fetch = FetchType.LAZY,mappedBy = "displayPolicyConfiguration")
   */
  @ApiModelProperty("销量目标")
  @TableField(exist = false)
  private DisplayPolicySaleTarget saleTarget;

  /**
   * 每月上传次数
   */
  @ApiModelProperty("每月上传次数")
  @TableField(value = "upload_times")
  @Column(name = "upload_times", nullable = false, length = 4, columnDefinition = "int(4) COMMENT ' 每月上传次数 '")
  private Integer uploadTimes;

  /**
   * 陈列上传规则
   *
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "displayPolicyConfiguration")
   */
  @ApiModelProperty("陈列上传规则")
  @TableField(exist = false)
  private Set<DisplayPolicyUploadRule> uploadRules;

  /**
   * 陈列类型
   */
  @ApiModelProperty("陈列类型")
  @TableField(value = "display_type")
  @Column(name = "display_type", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 陈列类型 '")
  private String displayType;

  /**
   * 陈列示例图
   */
  @ApiModelProperty("陈列示例图")
  @TableField(exist = false)
  private Set<DisplayTaskUploadDetail> displaySampleGraphs;

  /**
   * 扫码产品维度标识(品牌code，系列code，大类code，小类code)
   */
  @ApiModelProperty("扫码产品维度标识")
  @TableField(value = "dimension_flag")
  @Column(name = "dimension_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 扫码产品维度标识 '")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称(品牌，系列，大类，小类)
   */
  @ApiModelProperty("扫码产品维度名称")
  @TableField(value = "dimension_name")
  @Column(name = "dimension_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 扫码产品维度名称 '")
  private String dimensionName;

  /**
   * 政策关联配置列表
   *
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "displayPolicyConfiguration")
   */
  @ApiModelProperty("政策关联配置列表")
  @TableField(exist = false)
  private Set<DisplayPolicyConfiguration> displayPolicyConfigurations;

  /**
   * 陈列说明
   */
  @ApiModelProperty("陈列说明")
  @TableField(value = "display_explain")
  @Column(name = "display_explain", columnDefinition = "text COMMENT ' 陈列示例图 '")
  private String displayExplain ;
}
