package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Set;

/**
 * 陈列政策配置
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayPolicyConfiguration", description = "陈列政策配置")
@TableName("ladder_display_policy_configuration")
public class DisplayPolicyConfiguration extends BaseIdEntity {

  private static final long serialVersionUID = 4228363826820555441L;

  /**
   * 陈列政策id
   */
  @ApiModelProperty("陈列政策id")
  @TableField(value = "display_policy_id")
  @Column(name = "display_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策id '")
  private String displayPolicyId;

  /**
   * 协议阶梯编码
   */
  @ApiModelProperty("协议阶梯编码")
  @TableField(value = "agreement_ladder_code")
  @Column(name = "agreement_ladder_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议阶梯编码 '")
  private String agreementLadderCode;

  /**
   * 是否只使用最高级别返利(Y/N)
   */
  @ApiModelProperty("是否只使用最高级别返利(Y/N)")
  @TableField(value = "only_highest_level")
  @Column(name = "only_highest_level", nullable = false, length = 2, columnDefinition = "VARCHAR(64) COMMENT ' 是否只使用最高级别返利(Y/N) '")
  private String onlyHighestLevel;


  /**
   * 陈列面达标个数
   */
  @ApiModelProperty("陈列面达标个数")
  @TableField(value = "display_number")
  @Column(name = "display_number", nullable = false, length = 16, columnDefinition = "int(64) COMMENT ' 陈列面达标个数 '")
  private Integer displayNumber;

  /**
   * 陈列政策产品范围
   *
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "displayPolicyConfiguration")
   */
  @ApiModelProperty("陈列政策产品范围")
  @TableField(exist = false)
  private Set<DisplayPolicyRange> displayPolicyRanges;

  /**
   * 配置关联分利表达式列表
   */
  @ApiModelProperty("配置关联分利表达式列表")
  @TableField(exist = false)
  private Set<DisplayPolicyExpression> displayPolicyExpressions;



}
