package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 陈列政策分利表达式实体
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayPolicyExpression", description = "陈列政策分利表达式实体")
@TableName("ladder_display_policy_expression")
public class DisplayPolicyExpression extends BaseIdEntity {
  private static final long serialVersionUID = -7146208492564155031L;

  /**
   * 政策配置id
   */
  @ApiModelProperty("政策配置id")
  @TableField(value = "configuration_id")
  @Column(name = "configuration_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 政策配置id '")
  private String configurationId;

  /**
   * 奖励条件标志(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件标志(固定额度，定额随机)")
  @TableField(value = "award_condition_flag")
  @Column(name = "award_condition_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 奖励条件标志(固定额度，定额随机) '")
  private String awardConditionFlag;

  /**
   * 奖励条件名称(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件名称(固定额度，定额随机)")
  @TableField(value = "award_condition_name")
  @Column(name = "award_condition_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 奖励条件名称(固定额度，定额随机)'")
  private String awardConditionName;

  /**
   * 奖励方式标志
   */
  @ApiModelProperty("奖励方式标志")
  @TableField(value = "reward_method_flag")
  @Column(name = "reward_method_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(64) COMMENT ' 奖励方式标志 '")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称
   */
  @ApiModelProperty("奖励方式名称")
  @TableField(value = "reward_method_name")
  @Column(name = "reward_method_name", nullable = false, length = 16, columnDefinition = "VARCHAR(64) COMMENT ' 奖励方式名称 '")
  private String rewardMethodName;

  /**
   * 陈列面达标个数
   */
  @ApiModelProperty("陈列面达标个数")
  @TableField(value = "display_number")
  @Column(name = "display_number", nullable = false, length = 16, columnDefinition = "int(64) COMMENT ' 陈列面达标个数 '")
  private Integer displayNumber;

  /**
   * 奖励数据
   */
  @ApiModelProperty("奖励数据")
  @TableField(value = "reward_data")
  @Column(name = "reward_data", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 奖励额度 '")
  private BigDecimal rewardData;

  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  @Column(name = "gift_code", nullable = false, length = 16, columnDefinition = "VARCHAR(128) COMMENT ' 赠品编码 '")
  @TableField(value = "gift_code")
  private String giftCode;

  /**
   * 陈列计算周期(月,季度，半年，年)
   */
  @ApiModelProperty("陈列达成计算周期(月,季度，半年，年)")
  @TableField(value = "calculate_cycle")
  @Column(name = "calculate_cycle", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列计算达成周期(月,季度，半年，年) '")
  private String calculateCycle;

  /**
   * 表达式特殊编码
   */
  @ApiModelProperty("表达式特殊编码")
  @TableField(value = "special_code")
  @Column(name = "special_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 表达式特殊编码 '")
  private String specialCode;

  /**
   * 阶梯达成比例
   */
  @ApiModelProperty("阶梯达成比例")
  @TableField(value = "reach_rate")
  @Column(name = "reach_rate", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 达成比例 '")
  private BigDecimal reachRate;
}
