package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 陈列政策产品范围
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayPolicyRange", description = "陈列奖励计算规则")
@TableName("ladder_display_policy_range")
public class DisplayPolicyRange extends BaseIdEntity {

  private static final long serialVersionUID = 6003526954635201976L;

  /**
   * 政策配置id
   */
  @ApiModelProperty("政策配置id")
  @TableField(value = "configuration_id")
  @Column(name = "configuration_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 政策配置id '")
  private String configurationId;

  /**
   * 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)
   *
   * @Column(name = "special_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32)
   * COMMENT ' 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码) '")
   */
  @ApiModelProperty("有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码)")
  @TableField(value = "special_code")
  @Column(name = "special_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 有特定业务含义的标识字符串(特征编码，比如：品牌编码、系列编码) '")
  private String specialCode;

  /**
   * 汉字名称
   *
   * @Column(name = "special_name", nullable = false, length = 32, columnDefinition = "VARCHAR(32)
   * COMMENT ' 汉字名称 '")
   */
  @ApiModelProperty("汉字名称")
  @TableField(value = "special_name")
  @Column(name = "special_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 汉字名称 '")
  private String specialName;
}
