package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 销量目标
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayPolicySaleTarget", description = "销量目标")
@TableName("ladder_display_policy_sale_target")
public class DisplayPolicySaleTarget extends BaseIdEntity {

  private static final long serialVersionUID = 6003526954635201976L;

  /**
   * 陈列政策id
   */
  @ApiModelProperty("陈列政策id")
  @TableField(value = "display_policy_id")
  @Column(name = "display_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策id '")
  private String displayPolicyId;

  /**
   * 销量目标总数 当绑定销量目标时 此字段有值
   */
  @ApiModelProperty("销量目标总数")
  @TableField(value = "total_sale")
  @Column(name = "total_sale", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 销量目标总数 '")
  private BigDecimal totalSale;

  /**
   * 一月份销量（标箱）
   */
  @ApiModelProperty("一月份销量（标箱）")
  @TableField(value = "january_sale_num")
  @Column(name = "january_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 一月份销量（标箱） '")
  private BigDecimal januarySaleNum;

  /**
   * 二月份销量（标箱）
   */
  @ApiModelProperty("二月份销量（标箱）")
  @TableField(value = "february_sale_num")
  @Column(name = "february_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 二月份销量（标箱） '")
  private BigDecimal februarySaleNum;

  /**
   * 三月份销量（标箱）
   */
  @ApiModelProperty("三月份销量（标箱）")
  @TableField(value = "march_sale_num")
  @Column(name = "march_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 三月份销量（标箱） '")
  private BigDecimal marchSaleNum;

  /**
   * 四月份销量（标箱）
   */
  @ApiModelProperty("四月份销量（标箱）")
  @TableField(value = "april_sale_num")
  @Column(name = "april_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 四月份销量（标箱） '")
  private BigDecimal aprilSaleNum;

  /**
   * 五月份销量（标箱）
   */
  @ApiModelProperty("五月份销量（标箱）")
  @TableField(value = "may_sale_num")
  @Column(name = "may_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 五月份销量（标箱） '")
  private BigDecimal maySaleNum;

  /**
   * 六月份销量（标箱）
   */
  @ApiModelProperty("六月份销量（标箱）")
  @TableField(value = "june_sale_num")
  @Column(name = "june_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 六月份销量（标箱） '")
  private BigDecimal juneSaleNum;

  /**
   * 七月份销量（标箱）
   */
  @ApiModelProperty("七月份销量（标箱）")
  @TableField(value = "july_sale_num")
  @Column(name = "july_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 七月份销量（标箱） '")
  private BigDecimal julySaleNum;

  /**
   * 八月份销量（标箱）
   */
  @ApiModelProperty("八月份销量（标箱）")
  @TableField(value = "august_sale_num")
  @Column(name = "august_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 八月份销量（标箱） '")
  private BigDecimal augustSaleNum;

  /**
   * 九月份销量（标箱）
   */
  @ApiModelProperty("九月份销量（标箱）")
  @TableField(value = "september_sale_num")
  @Column(name = "september_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 九月份销量（标箱） '")
  private BigDecimal septemberSaleNum;

  /**
   * 十月份销量（标箱）
   */
  @ApiModelProperty("十月份销量（标箱）")
  @TableField(value = "october_sale_num")
  @Column(name = "october_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十月份销量（标箱） '")
  private BigDecimal octoberSaleNum;

  /**
   * 十一月份销量（标箱）
   */
  @ApiModelProperty("十一月份销量（标箱）")
  @TableField(value = "november_sale_num")
  @Column(name = "november_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十一月份销量（标箱） '")
  private BigDecimal novemberSaleNum;

  /**
   * 十二月份销量（标箱）
   */
  @ApiModelProperty("十二月份销量（标箱）")
  @TableField(value = "december_sale_num")
  @Column(name = "december_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十二月份销量（标箱） '")
  private BigDecimal decemberSaleNum;
}
