package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 陈列上传规则
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayPolicyUploadRule", description = "陈列上传规则")
@TableName("ladder_display_policy_upload_rule")
public class DisplayPolicyUploadRule extends BaseIdEntity {
  private static final long serialVersionUID = -6153688006676538134L;

  /**
   * 陈列政策id
   */
  @ApiModelProperty("陈列政策id")
  @TableField(value = "display_policy_id")
  @Column(name = "display_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策id '")
  private String displayPolicyId;

  /**
   * 排序使用
   */
  @ApiModelProperty("排序使用")
  @TableField(value = "order_num")
  @Column(name = "order_num", nullable = false, length = 4, columnDefinition = "int(4) COMMENT ' 排序使用 '")
  private Integer orderNum;

  /**
   * 开始时间（号）
   */
  @ApiModelProperty("开始时间（号）")
  @TableField(value = "start_day")
  @Column(name = "start_day", nullable = false, length = 4, columnDefinition = "int(4) COMMENT ' 开始时间（号） '")
  private Integer startDay;

  /**
   * 结束时间（号）
   */
  @ApiModelProperty("结束时间（号）")
  @TableField(value = "end_day")
  @Column(name = "end_day", nullable = false, length = 4, columnDefinition = "int(4) COMMENT ' 结束时间（号） '")
  private Integer endDay;
}
