package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author HuaHongQiang
 * @date 2021/8/15 16:29
 * 陈列政策任务实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayTask", description = "陈列政策任务实体")
@TableName("ladder_display_task")
public class DisplayTask extends TenantOpEntity {
  
  private static final long serialVersionUID = -1676624416115160326L;

  /**
   * 业务单号(生成陈列任务时生成)
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 任务名称(根据协议和协议划定每月陈列任务次数命名，政策进行生成)
   */
  @ApiModelProperty("任务名称")
  @TableField(value = "task_name")
  @Column(name = "task_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务名称 '")
  private String taskName;

  /**
   * 任务状态(待开始，执行中，已完成，未完成)
   */
  @ApiModelProperty("任务状态(待开始，执行中，已完成，未完成)")
  @TableField(value = "task_status")
  @Column(name = "task_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务状态(待开始，执行中，待审核，已完成，未完成) '")
  private String taskStatus;

  /**
   * 审核状态(待AI审核、待人工审核，AI审核通过、逾期未审核自动通过、人工审核通过，AI已驳回、逾期未提交审核不通过、人工审核不通过)
   */
  @ApiModelProperty("审核状态(待AI审核、待人工审核，AI审核通过、逾期未审核自动通过、人工审核通过，AI已驳回、逾期未提交审核不通过、人工审核不通过)")
  @TableField(value = "audit_status")
  @Column(name = "audit_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 审核状态(待AI审核、待人工审核，AI审核通过、逾期未审核自动通过、人工审核通过，AI已驳回、逾期未提交审核不通过、人工审核不通过) '")
  private String auditStatus;

  /**
   * 陈列政策id
   */
  @ApiModelProperty("陈列政策id")
  @TableField(value = "display_policy_id")
  @Column(name = "display_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策id '")
  private String displayPolicyId;

  /**
   * 陈列政策配置id
   */
  @ApiModelProperty("陈列政策配置id")
  @TableField(value = "display_policy_configuration_id")
  @Column(name = "display_policy_configuration_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列政策配置id '")
  private String displayPolicyConfigurationId;

  /**
   * 所属协议id
   */
  @ApiModelProperty("所属协议id")
  @TableField(value = "agreement_id")
  @Column(name = "agreement_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属协议id '")
  private String agreementId;

  /**
   * 所属协议名称
   */
  @ApiModelProperty("所属协议名称")
  @TableField(value = "agreement_name")
  @Column(name = "agreement_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属协议名称 '")
  private String agreementName;

  /**
   * 所属模板id
   */
  @ApiModelProperty("所属模板id")
  @TableField(value = "template_id")
  @Column(name = "template_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属模板id '")
  private String templateId;

  /**
   * 所属模板名称
   */
  @ApiModelProperty("所属模板名称")
  @TableField(value = "template_name")
  @Column(name = "template_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属模板名称 '")
  private String templateName;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 终端编码 '")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 终端名称 '")
  private String terminalName;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @TableField(value = "task_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "task_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 任务开始时间 '")
  private Date taskStartTime;

  /**
   * 任务结束时间
   */
  @ApiModelProperty("任务结束时间")
  @TableField(value = "task_end_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "task_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 任务结束时间 '")
  private Date taskEndTime;

  /**
   * AI审核结果
   */
  @ApiModelProperty("AI审核结果")
  @TableField(value = "ai_audit_result")
  @Column(name = "ai_audit_result", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' AI审核结果 '")
  private String aiAuditResult;

  /**
   * 最终审核结果
   */
  @ApiModelProperty("最终审核结果")
  @TableField(value = "final_audit_result")
  @Column(name = "final_audit_result", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 最终审核结果 '")
  private String finalAuditResult;

  /**
   * 备注(驳回或未通过原因)
   */
  @ApiModelProperty("备注(驳回或未通过原因)")
  @TableField(value = "remark")
  @Column(name = "remark", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 备注(驳回或未通过原因) '")
  private String remark;

  /**
   * 陈列任务上传图片次数
   */
  @ApiModelProperty("陈列任务上传图片次数")
  @TableField(exist = false)
  @Column(name = "upload_picture_number", nullable = false, length = 4, columnDefinition = "int(4) COMMENT ' 陈列任务上传图片次数 '")
  private Integer uploadPictureNumber;

  /**
   * 陈列任务上传图片
   */
  @ApiModelProperty("陈列任务上传图片")
  @TableField(exist = false)
  private Set<DisplayTaskUploadDetail> displayTaskUploadDetails;

  /**
   * 是否绑定销量目标
   */
  @ApiModelProperty("是否绑定销量目标")
  @TableField(value = "bind_sale_status")
  @Column(name = "bind_sale_status", nullable = false, length = 4, columnDefinition = "VARCHAR(4) COMMENT ' 是否绑定销量目标 '")
  private String bindSaleStatus;

  /**
   * 销量目标
   */
  @ApiModelProperty("销量目标")
  @TableField(value = "sale_target")
  @Column(name = "sale_target", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 销量目标 '")
  private BigDecimal saleTarget;

  /**
   * 协议生效开始日期
   */
  @ApiModelProperty("协议生效开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "effective_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 协议生效开始日期 '")
  private Date effectiveStartTime;

  /**
   * 协议生效结束日期
   */
  @ApiModelProperty("协议生效结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "effective_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 协议生效结束日期 '")
  private Date effectiveEndTime;

  /**
   * 提交人工审核时间
   */
  @ApiModelProperty("提交人工审核时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "reject_time", nullable = false, columnDefinition = "datetime COMMENT ' 提交人工审核时间 '")
  private Date rejectTime;

  /**
   * 陈列类型
   */
  @ApiModelProperty("陈列类型")
  @TableField(value = "display_type")
  @Column(name = "display_type", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 陈列类型 '")
  private String displayType;

  /**
   * 驳回时间
   */
  @ApiModelProperty("人工审核时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "human_audit_time", nullable = false, columnDefinition = "datetime COMMENT ' 人工审核时间 '")
  private Date humanAuditTime;
}
