package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author HuaHongQiang
 * @date 2021/8/30 16:08
 * 陈列政策任务结算详情
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayTaskDetail", description = "陈列政策任务分利详情")
@TableName("ladder_display_task_detail")
public class DisplayTaskDetail extends DisplayPolicyExpression {

  private static final long serialVersionUID = 1753856760216612271L;

  /**
   * 业务单号(生成包量任务时生成)
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 是否绑定销量目标
   */
  @ApiModelProperty("是否绑定销量目标")
  @TableField(value = "bind_sale_status")
  @Column(name = "bind_sale_status", nullable = false, length = 4, columnDefinition = "VARCHAR(4) COMMENT ' 是否绑定销量目标 '")
  private String bindSaleStatus;

  /**
   * 销量目标
   */
  @ApiModelProperty("销量目标")
  @TableField(value = "sale_target")
  @Column(name = "sale_target", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 销量目标 '")
  private BigDecimal saleTarget;

  /**
   * 实际销量
   */
  @ApiModelProperty("实际销量")
  @TableField(value = "actual_sales")
  @Column(name = "actual_sales", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 实际销量 '")
  private BigDecimal actualSales;

  /**
   * 分利状态(Y/N)
   */
  @ApiModelProperty("分利状态(Y/N)")
  @TableField(value = "profit_status")
  @Column(name = "profit_status", precision = 20, scale = 4, columnDefinition = "VARCHAR(4) COMMENT ' 分利状态(Y/N) '")
  private String profitStatus;

  /**
   * 阶梯达成比例
   */
  @ApiModelProperty("阶梯达成比例")
  @TableField(value = "reach_rate")
  @Column(name = "reach_rate", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 达成比例 '")
  private BigDecimal reachRate;
}
