package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 陈列任务扫码数据
 *
 * @author sunx
 * @date 2021/12/16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "DisplayTaskScanCode", description = "陈列任务扫码数据")
@TableName("ladder_display_task_scan_code")
public class DisplayTaskScanCode extends UuidEntity {
  /** 业务单号(生成包量任务时生成) */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(
      name = "business_code",
      nullable = false,
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /** 数量 */
  @ApiModelProperty("数量")
  @TableField(value = "amount")
  private BigDecimal amount;

  /** 条码 */
  @ApiModelProperty("条码")
  @TableField(value = "bar_code")
  @Column(
      name = "bar_code",
      nullable = false,
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT ' 条码 '")
  private String barCode;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(
      name = "product_code",
      nullable = false,
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 租户编号 @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT
   * '租户编号'")
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  @TableField(value = "tenant_code")
  private String tenantCode;
}
