package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * @author HuaHongQiang
 * @date 2021/8/26 11:40
 * 陈列政策任务上传图片实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "display_task_upload", description = "陈列政策任务上传图片实体")
@TableName("ladder_display_task_upload")
public class DisplayTaskUpload extends TenantOpEntity {
  private static final long serialVersionUID = 3290402743447250081L;

  /**
   * 业务单号
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 上传图片次数(第几次)
   */
  @ApiModelProperty("上传图片次数(第几次)")
  @TableField(value = "upload_number")
  @Column(name = "upload_number", nullable = false, length = 4, columnDefinition = "int(4) COMMENT ' 上传图片次数(第几次) '")
  private Integer uploadNumber;

  /**
   * 上传图片地址
   */
  @ApiModelProperty("上传图片数量")
  @TableField(value = "picture_number")
  @Column(name = "picture_number", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 上传图片数量 '")
  private Integer pictureNumber;


  /**
   * AI审核结果
   */
  @ApiModelProperty("AI审核结果")
  @TableField(value = "ai_audit_result")
  @Column(name = "ai_audit_result", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' AI审核结果 '")
  private String aiAuditResult;

  /**
   * 最终审核结果
   */
  @ApiModelProperty("最终审核结果")
  @TableField(value = "final_audit_result")
  @Column(name = "final_audit_result", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 最终审核结果 '")
  private String finalAuditResult;

  /**
   * 备注(驳回或未通过原因)
   */
  @ApiModelProperty("备注(驳回或未通过原因)")
  @TableField(value = "remark")
  @Column(name = "remark", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 备注(驳回或未通过原因) '")
  private String remark;

  /**
   * 上传图片列表
   */
  @ApiModelProperty("上传图片列表")
  @TableField(exist = false)
  private List<DisplayTaskUploadDetail> displayTaskUploadDetails;

}
