package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 陈列政策任务上传图片审核信息
 * @author sunx
 * @date 2021/12/17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "display_task_upload_audit", description = "陈列政策任务上传图片审核信息")
@TableName("display_task_upload_audit")
public class DisplayTaskUploadAudit extends TenantOpEntity {

  /**
   * 图片上传记录id
   */
  @ApiModelProperty("图片上传记录id")
  @TableField(value = "display_task_upload_id")
  @Column(name = "display_task_upload_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图片上传记录id '")
  private String displayTaskUploadId;

  /**
   * 陈列审核类型
   */
  @ApiModelProperty("陈列审核类型")
  @TableField(value = "display_audit_type")
  @Column(name = "display_audit_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列审核类型 '")
  private String displayAuditType;

  /**
   * 陈列审核状态
   */
  @ApiModelProperty("陈列审核状态")
  @TableField(value = "audit_status")
  @Column(name = "audit_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 陈列审核状态 '")
  private String auditStatus;

  /**
   * 备注(驳回或未通过原因)
   */
  @ApiModelProperty("备注(驳回或未通过原因)")
  @TableField(value = "remark")
  @Column(name = "remark", nullable = false, length = 120, columnDefinition = "VARCHAR(120) COMMENT ' 备注(驳回或未通过原因) '")
  private String remark;
}
