package com.biz.crm.cps.business.policy.display.ladder.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author jerry7
 * 陈列政策任务上传图片详情
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "display_task_upload_detail", description = "陈列政策任务上传图片详情")
@TableName("ladder_display_task_upload_detail")
public class DisplayTaskUploadDetail extends TenantOpEntity {
  private static final long serialVersionUID = 3290402743447250081L;

  /**
   * 业务单号
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 上传id
   */
  @ApiModelProperty("上传id")
  @TableField(value = "upload_id")
  @Column(name = "upload_Id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 上传id '")
  private String uploadId;

  /**
   * 上传图片地址
   */
  @ApiModelProperty("上传图片地址")
  @TableField(value = "picture_url")
  @Column(name = "picture_url", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 上传图片地址 '")
  private String pictureUrl;

  /**
   * 图片序号
   */
  @ApiModelProperty("图片序号")
  @TableField(value = "picture_serial_number")
  @Column(name = "picture_serial_number", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 图片序号 '")
  private String pictureSerialNumber;


}
