package com.biz.crm.cps.business.policy.display.ladder.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 陈列计算政策配置 的 mybatis-plus接口类 {@link DisplayTask}
 *
 * @author jerry7
 */
public interface DisplayCalculateTaskMapper extends BaseMapper<DisplayCalculateTask> {

  /**
   * 条件查询陈列计算任务列表
   *
   * @param displayTaskDto 筛选条件
   * @return 陈列计算任务列表
   */
  List<DisplayCalculateTask> findByConditions(@Param("dto") DisplayTaskDto displayTaskDto);

  /**
   * 根据业务编码查询陈列计算任务
   *
   * @param businessCode 业务编码
   * @return 陈列计算任务实体
   */
  DisplayCalculateTask findByBusinessCode(@Param("businessCode") String businessCode);

  /**
   * 获取终端当前正在执行的陈列分利任务
   *
   * @param terminalCode
   * @param taskStatus
   * @param tenantCode
   * @return
   */
  List<DisplayCalculateTask> findCurrentRunningTaskByTerminalCode(
      @Param("terminalCode") String terminalCode,
      @Param("taskStatus") String taskStatus,
      @Param("tenantCode") String tenantCode);
}
