package com.biz.crm.cps.business.policy.display.ladder.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTaskRelateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayCalculateTaskRelateTaskModelVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 陈列任务与陈列明细任务关联关系mapper
 *
 * @author sunx
 * @date 2021/12/18
 */
public interface DisplayCalculateTaskRelateTaskMapper
    extends BaseMapper<DisplayCalculateTaskRelateTask> {

  /**
   * 根据陈列任务业务编码集合获取关联信息集合
   *
   * @param taskCodeList
   * @return
   */
  List<DisplayCalculateTaskRelateTaskModelVo> findByTaskCodes(
      @Param("list") List<String> taskCodeList);

  /**
   * 根据陈列明细任务编码集合获取关联信息集合
   *
   * @param detailCodeList
   * @return
   */
  List<DisplayCalculateTaskRelateTaskModelVo> findByDetailCodes(
      @Param("list") List<String> detailCodeList);
}
