package com.biz.crm.cps.business.policy.display.ladder.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayPolicyDto;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;

import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayPolicyConfigModelVo;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 陈列政策mapper
 * @author HuaHongQiang
 * @date 2021/8/9 19:02
 */
public interface DisplayPolicyMapper extends BaseMapper<DisplayPolicy> {

  /**
   * 根据主键查询陈列政策详情
   * @param templateCode 模板编码
   * @return 陈列政策详情
   */
  DisplayPolicy findDetailsByTemplateCode(@Param("templateCode") String templateCode);

  /**
   * 条件查询陈列政策列表
   * @param dto 陈列政策查询条件
   * @return 陈列政策列表
   */
  List<DisplayPolicy> findByConditions(@Param("dto") DisplayPolicyDto dto);

  /**
   * 根据政策id集合获取维度配置明细信息
   *
   * @param policyIds
   * @return
   */
  List<DisplayPolicyConfigModelVo> findDisplayPolicyConfigModelVoByPolicyIds(
      @Param("list") Set<String> policyIds);

  /**
   * 根据政策id获取陈列实例图url地址集合
   *
   * @param policyId
   * @return
   */
  List<String> findPolicyUploadSamplePicUrlListByPolicyId(@Param("policyId") String policyId);
}
