package com.biz.crm.cps.business.policy.display.ladder.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

/**
 * 陈列政策配置 的 mybatis-plus接口类 {@link DisplayTask}
 *
 * @author HuaHongQiang
 */
public interface DisplayTaskMapper extends BaseMapper<DisplayTask> {

  /**
   * 条件查询陈列任务列表
   *
   * @param displayTaskDto 筛选条件
   * @return 陈列任务列表
   */
  List<DisplayTask> findByConditions(@Param("dto") DisplayTaskDto displayTaskDto);

  /**
   * 根据业务编码查询陈列任务
   *
   * @param businessCode 业务编码
   * @return 陈列任务实体
   */
  DisplayTask findByBusinessCode(@Param("businessCode") String businessCode);

  /**
   * 根据起止时间和任务状态查询对应陈列任务数量
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @param taskStatus 任务状态
   * @return 对应任务数量
   */
  Integer countByTaskTimeAndStatus(@Param("agreementId") String agreementId,@Param("startTime") Date startTime, @Param("endTime") Date endTime, @Param("taskStatus") String taskStatus);
}
