package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTaskRelateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayCalculateTaskRelateTaskMapper;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayCalculateTaskRelateTaskModelVo;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 陈列任务与陈列明细任务关联关系repository
 *
 * @author sunx
 * @date 2021/12/18
 */
@Component
public class DisplayCalculateTaskRelateTaskRepository
    extends ServiceImpl<DisplayCalculateTaskRelateTaskMapper, DisplayCalculateTaskRelateTask> {

  /**
   * 根据陈列任务业务编码集合获取关联信息集合
   *
   * @param taskCodeList
   * @return
   */
  public List<DisplayCalculateTaskRelateTaskModelVo> findByTaskCodes(List<String> taskCodeList) {
    return this.baseMapper.findByTaskCodes(taskCodeList);
  }

  /**
   * 根据陈列明细任务编码集合获取关联信息集合
   *
   * @param detailCodeList
   * @return
   */
  public List<DisplayCalculateTaskRelateTaskModelVo> findByDetailCodes(
      List<String> detailCodeList) {
    return this.baseMapper.findByDetailCodes(detailCodeList);
  }
}
