package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayCalculateTaskMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 陈列结算任务配置 的 数据库访问类 {@link DisplayCalculateTask}
 *
 * @author jerry7
 */
@Component
public class DisplayCalculateTaskRepository
    extends ServiceImpl<DisplayCalculateTaskMapper, DisplayCalculateTask> {

  /**
   * 条件查询陈列任务
   *
   * @return 陈列任务实体
   */
  public List<DisplayCalculateTask> findByConditions(DisplayTaskDto displayTaskDto) {
    return this.baseMapper.findByConditions(displayTaskDto);
  }

  /**
   * 根据业务单号查询包量任务
   *
   * @return 陈列任务实体
   */
  public DisplayCalculateTask findByBusinessCode(String businessCode) {
    return this.baseMapper.findByBusinessCode(businessCode);
  }

  /**
   * 根据终端编码查询陈列任务
   *
   * @param terminalCode 终端编码
   * @return 陈列任务手机列表Vo
   */
  public List<DisplayCalculateTask> findByTerminalCode(String terminalCode, String taskStatus) {
    List<String> taskStatusList = Lists.newArrayList();
    if (DisplayTaskStatusEnum.STATUS_NOT_PASS.getDictCode().equals(taskStatus)) {
      taskStatusList.add(taskStatus);
    } else if (DisplayTaskStatusEnum.STATUS_PASS.getDictCode().equals(taskStatus)) {
      taskStatusList.add(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
      taskStatusList.add(DisplayTaskStatusEnum.STATUS_OVERDUE_NOT_AUDIT.getDictCode());
    } else {
      taskStatusList.add(DisplayTaskStatusEnum.STATUS_WAIT.getDictCode());
      taskStatusList.add(DisplayTaskStatusEnum.STATUS_AI_REJECT.getDictCode());
      taskStatusList.add(DisplayTaskStatusEnum.STATUS_MANUALLY_REVIEW.getDictCode());
    }
    return this.baseMapper.selectList(
        new QueryWrapper<DisplayCalculateTask>()
            .eq("terminal_code", terminalCode)
            .in("task_status", taskStatusList));
  }

  /**
   * 获取终端当前正在执行的陈列分利任务
   *
   * @param terminalCode
   * @param taskStatus
   * @return
   */
  public List<DisplayCalculateTask> findCurrentRunningTaskByTerminalCode(
      String terminalCode, String taskStatus) {
    return this.baseMapper.findCurrentRunningTaskByTerminalCode(
        terminalCode, taskStatus, TenantUtils.getTenantCode());
  }

  /**
   * 根据业务编码获取陈列分利任务明细信息
   *
   * @param businessCodeList
   * @return
   */
  public List<DisplayCalculateTask> findByBusinessCodes(List<String> businessCodeList) {
    return this.lambdaQuery().in(DisplayCalculateTask::getBusinessCode, businessCodeList).list();
  }
}
