package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyConfiguration;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayPolicyConfigurationMapper;
import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 陈列政策配置 的 数据库访问类 {@link DisplayPolicyConfiguration}
 *
 * @author hecheng
 */
@Component
public class DisplayPolicyConfigurationRepository extends
    ServiceImpl<DisplayPolicyConfigurationMapper, DisplayPolicyConfiguration> {


  /**
   * 通过政策Id查询陈列政策配置
   * @param policyId 政策Id
   * @return 陈列政策
   */
  public List<DisplayPolicyConfiguration> findByDisplayPolicyId(String policyId){
    return this.baseMapper.findDetailsByPolicyId(policyId);
  }
}
