package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayPolicyDto;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayPolicyMapper;

import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayPolicyConfigModelVo;
import java.util.Set;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 陈列政策配置 的 数据库访问类 {@link DisplayPolicy}
 *
 * @author HuaHongQiang
 */
@Component
public class DisplayPolicyRepository extends ServiceImpl<DisplayPolicyMapper, DisplayPolicy> {


  /**
   * 通过模板编码查询陈列政策详情
   * @param templateCode 模板编码
   * @return 陈列政策
   */
  public DisplayPolicy findDetailByTemplateCode(String templateCode) {
    return this.baseMapper.findDetailsByTemplateCode(templateCode);
  }

  /**
   * 条件查询陈列政策列表
   * @param dto 陈列政策查询条件
   * @return 陈列政策列表
   */
  public List<DisplayPolicy> findByConditions(DisplayPolicyDto dto) {
    return this.baseMapper.findByConditions(dto);
  }

  /**
   * 通过主键查询陈列政策详情
   * @param id 主键
   * @return 陈列政策
   */
  public DisplayPolicy findById(@Param("id") String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据模板编码删除关联政策信息
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(DisplayPolicy::getTemplateCode, templateCode).remove();
  }

  /**
   * 根据政策id集合获取维度配置明细信息
   *
   * @param policyIds
   * @return
   */
  public List<DisplayPolicyConfigModelVo> findDisplayPolicyConfigModelVoByPolicyIds(Set<String> policyIds) {
    return this.baseMapper.findDisplayPolicyConfigModelVoByPolicyIds(policyIds);
  }

  /**
   * 根据政策id获取陈列实例图url地址集合
   *
   * @param policyId
   * @return
   */
  public List<String> findPolicyUploadSamplePicUrlListByPolicyId(String policyId) {
    return this.baseMapper.findPolicyUploadSamplePicUrlListByPolicyId(policyId);
  }
}
