package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayRangeDetailVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayRangeDetailVoMapper;
import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 陈列政策产品范围 的 数据库访问类 {@link DisplayPolicyRange}
 *
 * @author hecheng
 */
@Component
public class DisplayRangeDetailVoRepository extends
    ServiceImpl<DisplayRangeDetailVoMapper, DisplayRangeDetailVo> {

  /**
   * 通过陈列政策id查询产品范围
   * @param policyId 陈列政策id
   * @return 陈列政策
   */
  public List<DisplayRangeDetailVo> findById(String policyId) {
    return this.baseMapper.findByPolicyId(policyId);
  }
}
