package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayTaskMapper;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 陈列政策配置 的 数据库访问类 {@link DisplayTask}
 *
 * @author HuaHongQiang
 */
@Component
public class DisplayTaskRepository extends ServiceImpl<DisplayTaskMapper, DisplayTask> {


  /**
   * 条件查询陈列任务
   *
   * @return 陈列任务实体
   */
  public List<DisplayTask> findByConditions(DisplayTaskDto displayTaskDto) {
    return this.baseMapper.findByConditions(displayTaskDto);
  }

  /**
   * 根据业务单号查询包量任务
   *
   * @return 陈列任务实体
   */
  public DisplayTask findByBusinessCode(String businessCode) {
    return this.baseMapper.findByBusinessCode(businessCode);
  }

  /**
   * 根据终端编码查询陈列任务
   *
   * @param terminalCode 终端编码
   * @return 陈列任务手机列表Vo
   */
  public List<DisplayTask> findByTerminalCode(String terminalCode, String taskStatus) {
    return this.baseMapper.selectList(new QueryWrapper<DisplayTask>()
            .eq("terminal_code", terminalCode).eq("task_status", taskStatus)
            .orderBy(true, true, "task_start_time"));
  }

  /**
   * 根据起止时间和任务状态查询对应陈列任务数量
   *
   * @param startTime  开始时间
   * @param endTime    结束时间
   * @param taskStatus 任务状态
   * @return 对应任务数量
   */
  public Integer countByTaskTimeAndStatus(String agreementId, Date startTime, Date endTime, String taskStatus) {
    return baseMapper.countByTaskTimeAndStatus(agreementId, startTime, endTime, taskStatus);
  }

}
