package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadAudit;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayTaskUploadAuditMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 陈列任务上传图片审核repository
 *
 * @author sunx
 * @date 2021/12/17
 */
@Component
public class DisplayTaskUploadAuditRepository
    extends ServiceImpl<DisplayTaskUploadAuditMapper, DisplayTaskUploadAudit> {

  /**
   * 根据陈列上传id集合获取对应的审核日志信息
   *
   * @param displayTaskUploadIdList
   * @return
   */
  public List<DisplayTaskUploadAudit> findByDisplayTaskUploadIds(
      List<String> displayTaskUploadIdList) {
    return this.lambdaQuery()
        .in(DisplayTaskUploadAudit::getDisplayTaskUploadId, displayTaskUploadIdList)
        .orderByAsc(DisplayTaskUploadAudit::getCreateTime)
        .list();
  }
}
