package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayTaskUploadDetailMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 陈列政策配置 的 数据库访问类 {@link DisplayTaskUploadDetail}
 *
 * @author HuaHongQiang
 */
@Component
public class DisplayTaskUploadDetailRepository
    extends ServiceImpl<DisplayTaskUploadDetailMapper, DisplayTaskUploadDetail> {

  public List<DisplayTaskUploadDetail> findByBusinessCode(String businessCode) {
    return this.lambdaQuery()
        .eq(DisplayTaskUploadDetail::getBusinessCode, businessCode)
        .orderByAsc(DisplayTaskUploadDetail::getCreateTime)
        .list();
  }
}
