package com.biz.crm.cps.business.policy.display.ladder.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.mapper.DisplayTaskUploadMapper;

import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 陈列政策配置 的 数据库访问类 {@link DisplayTaskUploadDetail}
 *
 * @author HuaHongQiang
 */
@Component
public class DisplayTaskUploadRepository extends ServiceImpl<DisplayTaskUploadMapper, DisplayTaskUpload> {

  /**
   * 根据业务编码查询任务上传信息
   * @param businessCode 陈列任务业务编码
   * @return 陈列任务上传信息
   */
  public List<DisplayTaskUpload> findByBusinessCode(String businessCode) {
    return this.baseMapper.findByBusinessCode(businessCode);
  }

  /**
   * 根据id获取明细
   * @param id
   * @return
   */
  public DisplayTaskUpload findById(String id) {
    return this.baseMapper.selectById(id);
  }
}
