package com.biz.crm.cps.business.policy.display.ladder.local.service;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTaskRelateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayCalculateTaskRelateTaskModelVo;
import java.util.List;

/**
 * 陈列任务与陈列明细任务关联Service
 *
 * @author sunx
 * @date 2021/12/18
 */
public interface DisplayCalculateTaskRelateTaskService {

  /**
   * 批量保存
   *
   * @param list
   */
  void saveBatch(List<DisplayCalculateTaskRelateTask> list);

  /**
   * 根据陈列任务业务编码集合获取关联信息集合
   *
   * @param taskCodeList
   * @return
   */
  List<DisplayCalculateTaskRelateTaskModelVo> findByTaskCodes(List<String> taskCodeList);

  /**
   * 根据陈列明细任务编码集合获取关联信息集合
   *
   * @param detailCodeList
   * @return
   */
  List<DisplayCalculateTaskRelateTaskModelVo> findByDetailCodes(List<String> detailCodeList);
}
