package com.biz.crm.cps.business.policy.display.ladder.local.service;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import java.util.List;

/**
 * 陈列分利任务接口
 *
 * @author sunx
 * @date 2021/12/16
 */
public interface DisplayCalculateTaskService {

  /**
   * 扫码数据更新关联的分利任务实际扫码数据信息
   *
   * @param productCode
   * @param barCode
   */
  void updateScanInfoByProductCodeAndBarCode(String productCode, String barCode);

  /**
   * 根据业务编码获取明细
   *
   * @param businessCodeList
   * @return
   */
  List<DisplayCalculateTask> findByBusinessCodes(List<String> businessCodeList);
}
