package com.biz.crm.cps.business.policy.display.ladder.local.service;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayPolicyConfigModelVo;
import java.util.List;
import java.util.Set;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 14:00 陈列政策接口
 */
public interface DisplayPolicyService {

  /**
   * 创建陈列政策
   *
   * @param agreementPolicyDto 陈列政策实体
   * @return 创建结果
   */
  DisplayPolicy create(AgreementPolicyDto agreementPolicyDto);

  /**
   * 创建陈列政策
   *
   * @param displayPolicy 陈列政策实体
   * @return 创建结果
   */
  DisplayPolicy createFrom(DisplayPolicy displayPolicy);

  /**
   * 根据templateCode获取陈列政策详情
   *
   * @param templateCode 陈列政策主键
   * @return 陈列政策主体
   */
  DisplayPolicy findByTemplateCode(String templateCode);

  /**
   * 创建陈列政策是验证物料重复
   *
   * @param agreementTemplateVo 模板vo
   * @param agreementPolicyDto 政策vo
   */
  void validatePolicyScope(
      AgreementTemplateVo agreementTemplateVo, AgreementPolicyDto agreementPolicyDto);

  /**
   * 修改陈列政策
   *
   * @param deserialize
   * @param before
   */
  void update(AgreementPolicyDto deserialize, Boolean before);

  /**
   * 根据政策id集合获取维度配置明细信息
   *
   * @param policyIds
   * @return
   */
  List<DisplayPolicyConfigModelVo> findDisplayPolicyConfigModelVoByPolicyIds(Set<String> policyIds);

  /**
   * 根据政策id获取陈列实例图url地址集合
   *
   * @param policyId
   * @return
   */
  List<String> findPolicyUploadSamplePicUrlListByPolicyId(String policyId);
}
