package com.biz.crm.cps.business.policy.display.ladder.local.service;

import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadInfoDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import java.util.List;

/**
 * @author HuaHongQiang
 * @date 2021/8/9 18:57
 * 陈列任务接口
 */
public interface DisplayTaskService {

  /**
   * 创建陈列任务
   * 当协议签署成功后，协议包含包量政策时即根据协议的生效时间和计算周期生成陈列任务
   *
   * @param agreementId 协议id
   * @return 创建结果
   */
  List<DisplayTask> create(String agreementId);

  /**
   * 创建陈列任务
   * 当协议签署成功后，协议包含包量政策时即根据协议的生效时间和计算周期生成陈列任务
   *
   * @param agreementVo 协议id
   * @return 创建结果
   */
  List<DisplayTask> create(AgreementVo agreementVo);


  /**
   * 触发陈列任务方法(定时器)
   */
  void handleDisplayTask();

  /**
   * 结算陈列任务(定时器)
   * @param businessCode 业务单号
   */
  void handleSettlementTask(String businessCode);

  /**
   * 修改任务状态(人工审核)
   * @param displayTaskDto 陈列任务DTO
   */
  void updateTaskStatus(DisplayTaskDto displayTaskDto);

  /**
   * 上传陈列任务图片
   * @param displayTaskUploadInfoDto 陈列任务上传图片信息DTO
   */
  void handleSubmitDisplayTask(DisplayTaskUploadInfoDto displayTaskUploadInfoDto);


}
