package com.biz.crm.cps.business.policy.display.ladder.local.service.builder;

import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;

import java.util.List;

/**
 * @author jerry
 * @date 2021/09/27 19:27
 * 陈列分利任务装配策略
 */
public interface DisplayCalculateTaskBuilder {

  /**
   * 组装生成陈列分利任务
   * @param agreementVo 陈列协议
   * @param displayPolicy 陈列政策
   * @return 陈列任务
   */
  List<DisplayCalculateTask> handleAssemblyDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicy displayPolicy);

  /**
   * 陈列任务构造器对应结算周期，当需要新增构造器时请确保此周期类型与包量政策传递的结算周期一致
   * @return 结算周期
   */
  String quantifyTaskCycle();
}
