package com.biz.crm.cps.business.policy.display.ladder.local.service.builder;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.constant.DisplayConstant;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.utils.DisplayPolicyUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/09/27 19:43
 * 陈列任务的组装
 */
@Component
public class DisplayCalculateTaskHalfYearBuilder implements DisplayCalculateTaskBuilder {

  /**
   * 组装生成陈列计算任务
   */
  @Override
  public List<DisplayCalculateTask> handleAssemblyDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicy displayPolicy) {
    List<DisplayCalculateTask> taskList = Lists.newArrayList();
    if (!ObjectUtils.allNotNull(agreementVo, displayPolicy)) {
      return taskList;
    }
    Date effectiveTime = agreementVo.getEffectiveStartTime();
    Date now = new Date();
    DisplayTaskStatusNewEnum statusEnum = DisplayTaskStatusNewEnum.DEFAULT;
    if (effectiveTime.before(now)) {
      //当协议生效时间小于当前时间，即签署协议时协议已生效，则当前第一个任务为进行中，其余任务为待执行
      statusEnum = DisplayTaskStatusNewEnum.RUNNING;
    }
    while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(effectiveTime);
      //获取当前月份
      int nowMonth = calendar.get(Calendar.MONTH) + 1;
      //获取当前年份
      int nowYear = calendar.get(Calendar.YEAR);
      //获取当前时间到下一个半年度结算点的月份
      int addMonths = nowMonth % 6;
      //构造陈列计算任务
      DisplayCalculateTask displayCalculateTask = new DisplayCalculateTask();
      displayCalculateTask.setTaskStartTime(DateUtils.addMonths(DateUtils.ceiling(effectiveTime,Calendar.MONTH),-1));
      if (addMonths == 0) {
        //当前月份为当前半年度最后一个月，则下一个循环起点为下个月第一个时间点
        effectiveTime = DateUtils.ceiling(effectiveTime, Calendar.MONTH);
      } else {
        //当前月份不为当前半年度最后一个月，则下一个循环起点应补充到下一个半年度的第一个月份
        effectiveTime = DateUtils.addMonths(DateUtils.ceiling(effectiveTime, Calendar.MONTH), 6 - addMonths);
      }
      Date targetStartTime = displayCalculateTask.getTaskStartTime();
      displayCalculateTask.setTaskEndTime(DateUtils.addSeconds(effectiveTime, -1));
      int halfYear = nowMonth / 6;
      if (halfYear > 0) {
        displayCalculateTask.setTaskName(nowYear + "年下半年陈列结算任务");
        targetStartTime = DateUtils.setMonths(targetStartTime,6);
      } else {
        targetStartTime = DateUtils.setMonths(targetStartTime,0);
        displayCalculateTask.setTaskName(nowYear + "年上半年陈列结算任务");
      }
      displayCalculateTask.setTaskStatus(statusEnum.getDictCode());
      displayCalculateTask.setSaleTarget(DisplayPolicyUtils.getScaleByTimeInterval(targetStartTime,displayCalculateTask.getTaskEndTime(), displayPolicy.getSaleTarget()));
      taskList.add(displayCalculateTask);
      //同一个终端同一商品维度在同一时间段内只能存在一个陈列计算任务，故生成陈列计算任务后将后续任务状态置为待执行
      statusEnum = DisplayTaskStatusNewEnum.DEFAULT;
    }
    return taskList;
  }

  @Override
  public String quantifyTaskCycle() {
    return DisplayConstant.HALF_YEAR;
  }
}
