package com.biz.crm.cps.business.policy.display.ladder.local.service.builder;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.constant.DisplayConstant;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.utils.DisplayPolicyUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/09/27 19:43
 * 陈列计算任务的组装
 */
@Component
public class DisplayCalculateTaskMonthBuilder implements DisplayCalculateTaskBuilder {

  /**
   * 组装生成陈列计算任务
   */
  @Override
  public List<DisplayCalculateTask> handleAssemblyDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicy displayPolicy) {
    List<DisplayCalculateTask> taskList = Lists.newArrayList();
    if(!ObjectUtils.allNotNull(agreementVo,displayPolicy)){
      return taskList;
    }
    Date effectiveTime = agreementVo.getEffectiveStartTime();
    Date now = new Date();
    DisplayTaskStatusNewEnum statusEnum = DisplayTaskStatusNewEnum.DEFAULT;
    if (effectiveTime.before(now)) {
      //当协议生效时间小于当前时间，即签署协议时协议已生效，则当前第一个任务为进行中，其余任务为待执行
      statusEnum = DisplayTaskStatusNewEnum.RUNNING;
    }
    while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(effectiveTime);
      //获取当前月份
      int nowMonth = calendar.get(Calendar.MONTH) + 1;
      //获取当前年份
      int nowYear = calendar.get(Calendar.YEAR);
      //构造陈列计算任务
      DisplayCalculateTask displayCalculateTask = new DisplayCalculateTask();
      //设置开始时间为当月1号
      displayCalculateTask.setTaskStartTime(DateUtils.addMonths(DateUtils.ceiling(effectiveTime,Calendar.MONTH),-1));
      displayCalculateTask.setTaskEndTime(DateUtils.addSeconds(DateUtils.ceiling(effectiveTime, Calendar.MONTH), -1));
      displayCalculateTask.setTaskName(nowYear + "年第" + nowMonth + "月陈列结算任务");
      displayCalculateTask.setTaskStatus(statusEnum.getDictCode());
      displayCalculateTask.setSaleTarget(DisplayPolicyUtils.getScaleByMonth(nowMonth, displayPolicy.getSaleTarget()));
      taskList.add(displayCalculateTask);
      //同一个终端同一商品维度在同一时间段内只能存在一个陈列计算任务，故生成陈列计算任务后将后续任务状态置为待执行
      statusEnum = DisplayTaskStatusNewEnum.DEFAULT;
      //结算方式为月份，则以一个自然月为分割单位处理时间
      effectiveTime = DateUtils.ceiling(effectiveTime, Calendar.MONTH);
    }
    return taskList;
  }

  @Override
  public String quantifyTaskCycle() {
    return DisplayConstant.MONTH;
  }
}
