package com.biz.crm.cps.business.policy.display.ladder.local.service.builder;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.BindStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskAuditStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyUploadRule;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.utils.DisplayPolicyUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 19:43
 * 陈列任务的组装
 */
public class DisplayTaskDefaultBuilder implements DisplayTaskBuilder {

  /**
   * 组装生成陈列任务
   * 1.根据协议开始时间与当前时间做对比，判断第一个任务状态是否为待执行
   * 2.根据月份+政策陈列照上传频率生成多个任务
   */
  @Override
  public List<DisplayTask> handleAssemblyDisplayTask(AgreementVo agreementVo, DisplayPolicy displayPolicy) {
    List<DisplayTask> taskList = Lists.newArrayList();
    if (!ObjectUtils.allNotNull(agreementVo, displayPolicy)) {
      return taskList;
    }
    Date effectiveTime = agreementVo.getEffectiveStartTime();
    Date now = new Date();
    DisplayTaskStatusNewEnum statusEnum = DisplayTaskStatusNewEnum.DEFAULT;
    if (effectiveTime.before(now)) {
      effectiveTime = now;
    }
    while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(effectiveTime);
      //获取当前月份
      int nowMonth = calendar.get(Calendar.MONTH) + 1;
      //获取当前年份
      int nowYear = calendar.get(Calendar.YEAR);
      Validate.isTrue(!CollectionUtils.isEmpty(displayPolicy.getUploadRules()), "对应陈列政策上传规则为空！");
      List<DisplayPolicyUploadRule> uploadRuleList = displayPolicy.getUploadRules().stream()
              .sorted(Comparator.comparing(DisplayPolicyUploadRule::getOrderNum)).collect(
                      Collectors.toList());
      Validate.isTrue(!CollectionUtils.isEmpty(uploadRuleList), "对应陈列政策上传规则为空！");
      for (DisplayPolicyUploadRule uploadRule : uploadRuleList) {
        //设置任务开始时间与结束时间 例如2021-08-01 00:00:00  2021-08-10 23:59:59
        int days = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        if (uploadRule.getStartDay() > days) {
          continue;
        }
        int endDays = uploadRule.getEndDay() > days ? days : uploadRule.getEndDay();
        effectiveTime = DateUtils.setDays(DateUtils.ceiling(effectiveTime, Calendar.DAY_OF_MONTH), uploadRule.getStartDay());
        Date endTime = DateUtils.addSeconds(DateUtils.ceiling(DateUtils.setDays(effectiveTime, endDays), Calendar.DAY_OF_MONTH), -1);
        //任务列表还没有任务(此任务可能是第一个任务)，任务开始时间在
        if (taskList.size() == 0 && endTime.before(now)) {
          continue;
        }
        if (effectiveTime.before(now) && endTime.after(now)) {
          //当协议生效时间小于当前时间，即签署协议时协议已生效，则当前第一个任务为待执行，其余任务为未开始
          statusEnum = DisplayTaskStatusNewEnum.RUNNING;
        }
        //构造陈列任务
        DisplayTask displayTask = new DisplayTask();
        displayTask.setTaskStartTime(effectiveTime);
        displayTask.setTaskEndTime(endTime);
        displayTask.setTaskName(nowYear + "年" + nowMonth + "月第" + uploadRule.getOrderNum() + "次任务");
        displayTask.setTaskStatus(statusEnum.getDictCode());
        displayTask.setEffectiveStartTime(agreementVo.getEffectiveStartTime());
        displayTask.setEffectiveEndTime(agreementVo.getEffectiveEndTime());
        //设置销量
        if (BindStatusEnum.YES.getDictCode().equals(displayPolicy.getBindSaleStatus())) {
          displayTask.setSaleTarget(DisplayPolicyUtils.getScaleByMonth(nowMonth, displayPolicy.getSaleTarget()));
        } else {
          displayTask.setSaleTarget(BigDecimal.ZERO);
        }
        displayTask.setBindSaleStatus(displayPolicy.getBindSaleStatus());
        displayTask.setAuditStatus(DisplayTaskAuditStatusNewEnum.DEFAULT.getDictCode());
        taskList.add(displayTask);
        //除了第一个任务可能在执行中,其余任务都只可能待执行,任务状态置为待执行
        statusEnum = DisplayTaskStatusNewEnum.DEFAULT;
      }
      //时间置为下个月1号
      effectiveTime = DateUtils.ceiling(effectiveTime, Calendar.MONTH);
    }
    return taskList;
  }

}
