package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTaskRelateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayCalculateTaskRelateTaskModelVo;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayCalculateTaskRelateTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayCalculateTaskRelateTaskService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 陈列任务与陈列明细任务关联Service实现
 *
 * @author sunx
 * @date 2021/12/18
 */
@Service
public class DisplayCalculateTaskRelateTaskServiceImpl
    implements DisplayCalculateTaskRelateTaskService {
  @Autowired
  private DisplayCalculateTaskRelateTaskRepository displayCalculateTaskRelateTaskRepository;

  @Override
  @Transactional
  public void saveBatch(List<DisplayCalculateTaskRelateTask> list) {
    Validate.isTrue(!CollectionUtils.isEmpty(list), "关联关系不能为空");
    list.forEach(
        a -> {
          a.setTenantCode(TenantUtils.getTenantCode());
        });
    this.displayCalculateTaskRelateTaskRepository.saveBatch(list);
  }

  @Override
  public List<DisplayCalculateTaskRelateTaskModelVo> findByTaskCodes(List<String> taskCodeList) {
    if (CollectionUtils.isEmpty(taskCodeList)) {
      return Lists.newLinkedList();
    }
    return this.displayCalculateTaskRelateTaskRepository.findByTaskCodes(taskCodeList);
  }

  @Override
  public List<DisplayCalculateTaskRelateTaskModelVo> findByDetailCodes(
      List<String> detailCodeList) {
    if (CollectionUtils.isEmpty(detailCodeList)) {
      return Lists.newLinkedList();
    }
    return this.displayCalculateTaskRelateTaskRepository.findByDetailCodes(detailCodeList);
  }
}
