package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskAuditStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskUploadAuditTypeEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadHumanAuditDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditDetailVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditItemVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadAudit;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskAuditVoService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskUploadAuditService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 陈列任务审核相关接口实现
 *
 * @author sunx
 * @date 2021/12/17
 */
@Service
public class DisplayTaskAuditVoServiceImpl implements DisplayTaskAuditVoService {

  @Autowired private LoginUserService loginUserService;

  @Autowired private DisplayTaskRepository displayTaskRepository;

  @Autowired private DisplayPolicyService displayPolicyService;

  @Autowired private DisplayTaskUploadRepository displayTaskUploadRepository;

  @Autowired private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;

  @Autowired private DisplayTaskUploadAuditService displayTaskUploadAuditService;

  @Override
  public DisplayTaskAuditVo findTaskAuditByBusinessCode(String businessCode) {
    DisplayTask task = displayTaskRepository.findByBusinessCode(businessCode);
    if (Objects.isNull(task)) {
      return null;
    }
    DisplayTaskAuditVo vo = new DisplayTaskAuditVo();
    String displayPolicyId = task.getDisplayPolicyId();
    if (StringUtils.isNotBlank(displayPolicyId)) {
      vo.setSamplePicUrlList(
          this.displayPolicyService.findPolicyUploadSamplePicUrlListByPolicyId(displayPolicyId));
    }
    List<DisplayTaskUpload> taskUploadList =
        displayTaskUploadRepository.findByBusinessCode(businessCode);

    List<DisplayTaskUploadDetail> detailList =
        displayTaskUploadDetailRepository.findByBusinessCode(businessCode);

    if (CollectionUtils.isEmpty(taskUploadList)) {
      return vo;
    }
    // k-uploadId,v-pic地址集合
    Map<String, List<String>> mapPic = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(detailList)) {
      mapPic =
          detailList.stream()
              .filter(
                  a ->
                      StringUtils.isNotBlank(a.getUploadId())
                          && StringUtils.isNotBlank(a.getPictureUrl()))
              .collect(
                  Collectors.groupingBy(
                      DisplayTaskUploadDetail::getUploadId,
                      Collectors.mapping(
                          DisplayTaskUploadDetail::getPictureUrl, Collectors.toList())));
    }

    // 获取审核日志
    Map<String, List<DisplayTaskUploadAudit>> mapAudit = Maps.newHashMap();
    List<String> uploadIds =
        taskUploadList.stream().map(DisplayTaskUpload::getId).collect(Collectors.toList());
    if (!CollectionUtils.isEmpty(uploadIds)) {
      List<DisplayTaskUploadAudit> list =
          displayTaskUploadAuditService.findByDisplayTaskUploadIds(uploadIds);
      if (!CollectionUtils.isEmpty(list)) {
        mapAudit =
            list.stream()
                .filter(a -> StringUtils.isNotBlank(a.getDisplayTaskUploadId()))
                .collect(Collectors.groupingBy(DisplayTaskUploadAudit::getDisplayTaskUploadId));
      }
    }

    List<DisplayTaskAuditItemVo> itemVoList = Lists.newArrayList();
    for (DisplayTaskUpload item : taskUploadList) {
      DisplayTaskAuditItemVo cur = new DisplayTaskAuditItemVo();
      cur.setDisplayTaskUploadId(item.getId());
      cur.setUploadPicUrlList(mapPic.get(item.getId()));

      List<DisplayTaskUploadAudit> auditList = mapAudit.get(item.getId());
      if (!CollectionUtils.isEmpty(auditList)) {
        List<DisplayTaskAuditDetailVo> auditDetailVoList = Lists.newArrayList();
        for (DisplayTaskUploadAudit sub : auditList) {
          DisplayTaskAuditDetailVo detailVo = new DisplayTaskAuditDetailVo();
          detailVo.setAuditType(sub.getDisplayAuditType());
          detailVo.setAuditStatus(sub.getAuditStatus());
          detailVo.setRemark(sub.getRemark());
          detailVo.setAuditTime(sub.getCreateTime());
          detailVo.setUploadTime(item.getCreateTime());
          auditDetailVoList.add(detailVo);
        }
        cur.setAuditDetailVoList(auditDetailVoList);
      }
      itemVoList.add(cur);
    }
    vo.setItemVoList(itemVoList);
    return vo;
  }

  @Override
  @Transactional
  public void auditByHuman(DisplayTaskUploadHumanAuditDto dto) {
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未获取到操作人信息");
    Validate.notNull(dto, "参数不能为空");
    Validate.notBlank(dto.getDisplayTaskUploadId(), "陈列任务图片上传记录id不能为空");
    Validate.notBlank(dto.getAuditStatus(), "审核状态不能为空");
    Boolean f =
        DisplayTaskAuditStatusNewEnum.AUDIT_PASS.getDictCode().equals(dto.getAuditStatus())
            || DisplayTaskAuditStatusNewEnum.AUDIT_REJECT.getDictCode().equals(dto.getAuditStatus());
    Validate.isTrue(f, "人工审核状态异常");
    if (DisplayTaskAuditStatusNewEnum.AUDIT_REJECT.getDictCode().equals(dto.getAuditStatus())) {
      Validate.notBlank(dto.getRemark(), "备注不能为空");
    }
    DisplayTaskUploadAudit audit = new DisplayTaskUploadAudit();
    audit.setCreateAccount(loginUser.getAccount());
    audit.setCreateTime(new Date());
    audit.setAuditStatus(dto.getAuditStatus());
    audit.setDisplayAuditType(DisplayTaskUploadAuditTypeEnum.HUMAN.getDictCode());
    audit.setRemark(dto.getRemark());
    audit.setDisplayTaskUploadId(dto.getDisplayTaskUploadId());

    DisplayTaskUpload taskUpload = displayTaskUploadRepository.findById(dto.getDisplayTaskUploadId());
    Validate.notNull(taskUpload,"图片上传记录不存在!");

    DisplayTask task = displayTaskRepository.findByBusinessCode(taskUpload.getBusinessCode());
    Validate.notNull(task,"对应的陈列任务不存在!");
    task.setHumanAuditTime(new Date());
    task.setAuditStatus(dto.getAuditStatus());
    displayTaskRepository.saveOrUpdate(task);
    displayTaskUploadAuditService.create(audit);
  }
}
