package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayRangeDetailVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskDetailVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskUploadVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayRangeDetailVoRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 14:09
 * 陈列任务手机端详情Vo接口
 */
@Service
public class DisplayTaskDetailVoServiceImpl implements DisplayTaskDetailVoService {

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private DisplayTaskRepository displayTaskRepository;

  @Autowired
  private DisplayTaskUploadRepository uploadRepository;

  @Autowired
  private DisplayPolicyRepository displayPolicyRepository;

  @Autowired
  private DisplayRangeDetailVoRepository displayRangeDetailVoRepository;


  @Override
  public DisplayTaskDetailVo findDetailByBusinessCode(String businessCode) {
    if (StringUtils.isBlank(businessCode)){
      return null;
    }
    DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(businessCode);
    if (displayTask == null){
      return null;
    }
    DisplayPolicy displayPolicy = this.displayPolicyRepository.findById(displayTask.getDisplayPolicyId());
    if (displayPolicy == null){
      return null;
    }
    List<DisplayTaskUpload> displayTaskUploads = this.uploadRepository.findByBusinessCode(businessCode);
    List<DisplayRangeDetailVo> displayRangeDetailVos = this.displayRangeDetailVoRepository
        .findById(displayPolicy.getId());
    if (CollectionUtils.isEmpty(displayRangeDetailVos)){
      return null;
    }
    //装配数据
    DisplayTaskDetailVo displayTaskDetailVo = new DisplayTaskDetailVo();
    List<DisplayTaskUpload> displaySampleGraphs = this.uploadRepository
        .findByBusinessCode(displayPolicy.getId());
    if (!CollectionUtils.isEmpty(displaySampleGraphs)){
      Set<DisplayTaskUploadVo> displaySampleGraphVos = new HashSet<>(this.nebulaToolkitService
              .copyCollectionByWhiteList(displaySampleGraphs, DisplayTaskUpload.class,
                      DisplayTaskUploadVo.class, HashSet.class, ArrayList.class));
      displayTaskDetailVo.setDisplaySampleGraphs(displaySampleGraphVos);
    }
    displayTaskDetailVo.setBusinessCode(displayTask.getBusinessCode());
    displayTaskDetailVo.setTaskName(displayTask.getTaskName());
    displayTaskDetailVo.setTaskStatus(displayTask.getTaskStatus());
    displayTaskDetailVo.setRemark(displayTask.getRemark());
    displayTaskDetailVo.setUploadPictureNumber(displayTask.getUploadPictureNumber());
    displayTaskDetailVo.setDisplayRangeDetailVos(displayRangeDetailVos);
    if (!CollectionUtils.isEmpty(displayTaskUploads)){
      Set<DisplayTaskUploadVo> displayTaskUploadVos = new HashSet<>(nebulaToolkitService
              .copyCollectionByWhiteList(displayTaskUploads, DisplayTaskUpload.class,
                      DisplayTaskUploadVo.class, HashSet.class, ArrayList.class, "displayTaskUploadDetails"));
      displayTaskDetailVo.setDisplayTaskUploadVos(displayTaskUploadVos);
    }
    return displayTaskDetailVo;
  }



}
