package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskScanCode;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskScanCodeRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskScanCodeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 陈列任务扫码数据接口实现
 *
 * @author sunx
 * @date 2021/12/16
 */
@Service
public class DisplayTaskScanCodeServiceImpl implements DisplayTaskScanCodeService {
  @Autowired private DisplayTaskScanCodeRepository displayTaskScanCodeRepository;

  @Override
  @Transactional
  public void saveBatch(List<DisplayTaskScanCode> scanCodeList) {
    if (CollectionUtils.isEmpty(scanCodeList)) {
      return;
    }
    for (DisplayTaskScanCode item : scanCodeList) {
      item.setId(null);
      item.setTenantCode(TenantUtils.getTenantCode());
    }
    this.displayTaskScanCodeRepository.saveBatch(scanCodeList);
  }
}
