package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.constant.DisplayConstant;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.AuditResultEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.BindStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskAuditStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadInfoDto;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTaskRelateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyConfiguration;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyExpression;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskExpression;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayCalculateTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskExpressionRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayCalculateTaskRelateTaskService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.builder.DisplayCalculateTaskBuilder;
import com.biz.crm.cps.business.policy.display.ladder.local.service.builder.DisplayTaskBuilder;
import com.biz.crm.cps.business.policy.display.ladder.local.service.builder.DisplayTaskDefaultBuilder;
import com.biz.crm.cps.business.policy.display.ladder.local.service.observer.DisplayPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.service.strategy.AIDisplayAuditStrategy;
import com.biz.crm.cps.business.policy.display.ladder.local.utils.DisplaySchedulerUtils;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.biz.crm.cps.business.product.sdk.common.constant.MaterialDimensionConstant;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 14:09
 * 陈列任务接口实现
 */
@Service("displayTaskServiceImpl")
public class DisplayTaskServiceImpl implements DisplayTaskService {

  @Autowired
  private AgreementVoService agreementVoService;

  @Autowired
  private DisplayPolicyService displayPolicyService;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired
  private DisplayTaskRepository displayTaskRepository;

  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;

  @Autowired
  private MaterialVoService materialVoService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private List<PolicyRewardServiceObserver> policyRewardServiceObservers;

  @Autowired
  private DisplayTaskDetailRepository displayTaskDetailRepository;

  @Autowired
  private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;

  @Autowired
  private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;

  @Autowired
  private DisplayPolicyMountRegisterImpl displayPolicyMountRegister;

  @Autowired
  private List<DisplayCalculateTaskBuilder> displayCalculateTaskBuilders;

  @Autowired
  private AgreementLadderVoService agreementLadderVoService;

  @Autowired
  private DisplayCalculateTaskRepository displayCalculateTaskRepository;

  @Autowired
  private DisplayTaskExpressionRepository displayTaskExpressionRepository;

  @Autowired
  private DisplayTaskUploadRepository displayTaskUploadRepository;

  @Autowired
  private List<AIDisplayAuditStrategy> aiDisplayAuditStrategies;

  @Autowired
  private DisplayCalculateTaskRelateTaskService displayCalculateTaskRelateTaskService;

  /**
   * 根据协议id创建任务
   * step1:查询陈列协议信息
   * step2:创建任务列表
   *
   * @param agreementId 协议id
   * @return 陈列任务列表
   */
  @Override
  @Transactional
  public List<DisplayTask> create(String agreementId) {
    Validate.notBlank(agreementId, "协议id不能为空");
    //step1:根据协议id查询陈列协议信息
    LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
    loginUserAgreementDto.setAgreementCode(agreementId);
    AgreementDto agreementDto = new AgreementDto();
    agreementDto.setAgreementCode(agreementId);
    Page<AgreementVo> agreementVo = agreementVoService.findByConditions(PageRequest.of(0, 50), agreementDto);
    if (agreementVo != null && !CollectionUtils.isEmpty(agreementVo.getRecords())) {
      return this.create(agreementVo.getRecords().get(0));
    } else {
      return Lists.newArrayList();
    }
  }

  /**
   * step1:根据协议id查询陈列协议信息
   * step2:根据协议模板查询对应的陈列政策
   * step3:根据时间段和上传规则创建陈列任务
   * step4:保存陈列任务实体
   * step5:根据时间段创建陈列分利任务
   * step6:保存陈列分利任务实体
   * 陈列任务只进行陈列数据的数据和处理，不进行真正的分利行为，陈列结算任务处理真正的分利
   *
   * @param agreementVo 协议vo
   * @return 创建结果
   */
  @Override
  @Transactional
  public List<DisplayTask> create(AgreementVo agreementVo) {
    Validate.notNull(agreementVo, "协议实体不能为空");
    //step2:根据协议模板查询对应的陈列政策
    DisplayPolicy displayPolicy = displayPolicyService.findByTemplateCode(agreementVo.getTemplateCode());
    Validate.notNull(displayPolicy, "协议模板编码" + agreementVo.getAgreementCode() + "未找到对应的陈列政策！");
    DisplayTaskBuilder displayTaskBuilder = new DisplayTaskDefaultBuilder();
    //创建陈列任务列表
    List<DisplayTask> taskList = displayTaskBuilder.handleAssemblyDisplayTask(agreementVo, displayPolicy);
    if (!CollectionUtils.isEmpty(taskList)) {
      List<String> businessCodes = generateCodeService.generateCode(DisplayConstant.DISPLAY_TASK_CODE, taskList.size());
      Validate.isTrue(!CollectionUtils.isEmpty(businessCodes) && businessCodes.size() == taskList.size(), "生成业务单号异常");
      String tenantCode = TenantUtils.getTenantCode();
      for (int i = 0; i < taskList.size(); i++) {
        DisplayTask task = taskList.get(i);
        task.setBusinessCode(businessCodes.get(i));
        task.setDisplayPolicyId(displayPolicy.getId());
        task.setAgreementId(agreementVo.getAgreementCode());
        task.setAgreementName(agreementVo.getAgreementName());
        task.setTemplateId(agreementVo.getTemplateCode());
        task.setTemplateName(agreementVo.getBelongTemplate());
        task.setTerminalCode(agreementVo.getTerminalCode());
        task.setTerminalName(agreementVo.getRelationTerminal());
        task.setUploadPictureNumber(0);
        task.setDisplayType(displayPolicy.getDisplayType());
        task.setTenantCode(tenantCode);
      }
    }
    this.displayTaskRepository.saveBatch(taskList);
    //生成陈列分利任务
    List<DisplayCalculateTask> quantifyTasks = Lists.newArrayList();
    displayPolicy.getDisplayPolicyConfigurations().forEach(configuration -> {
      List<DisplayCalculateTask> quantifyTaskList = this.buildDisplayCalculateTask(agreementVo, configuration, displayPolicy);
      if (!CollectionUtils.isEmpty(quantifyTaskList)) {
        quantifyTasks.addAll(quantifyTaskList);
      }
    });

    // 设置陈列任务于陈列明细任务关系
    this.bindCalculateTaskRelateTask(quantifyTasks, taskList);

    this.displayCalculateTaskRepository.saveBatch(quantifyTasks);
    quantifyTasks.forEach(quantifyTask -> this.displayTaskExpressionRepository.saveBatch(quantifyTask.getDisplayTaskExpressionList()));
    //生成定时任务
    quantifyTasks.forEach(task -> {
              DynamicTaskSchedulerVo taskSchedulerVo = dynamicTaskSchedulerVoService.createIgnorePrefix(task.getBusinessCode(), "displayTaskServiceImpl", "handleSettlementTask"
                      , DisplaySchedulerUtils.getSchedulerCron(task.getTaskType()), agreementVo.getEffectiveEndTime(), task.getTaskName(), task.getBusinessCode());
              dynamicTaskSchedulerVoService.start(new String[]{taskSchedulerVo.getTaskCode()});
            }
    );
    return taskList;
  }



  /**
   * 定时器触发陈列任务方法
   * step1:启动开始时间为今日的陈列任务
   * step2:关闭结束时间为今日的陈列任务
   */
  @Override
  @DynamicTaskService(cornExpression = "0 0 0 * * ?", taskDesc = "启动/关闭陈列任务")
  @Transactional
  public void handleDisplayTask() {
    Date now = new Date();
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(now);
    //获取几天是几号
    int nowDay = calendar.get(Calendar.DAY_OF_MONTH);
    //step1:启动开始时间为今日的陈列任务
    Date startTime = DateUtils.ceiling(DateUtils.setDays(now, nowDay - 1), Calendar.DAY_OF_MONTH);
    this.startDisplayTaskBatch(startTime);
    //step2:关闭结束时间为昨日的陈列任务
    Date endTime = DateUtils.addSeconds(startTime, -1);
    this.closeDisplayTaskBatch(endTime);
  }

  /**
   * 陈列任务结算
   * step1：获取陈列任务实例
   * step2：根据协议的模板编码获取对应陈列政策
   * step3：陈列结算，构造陈列结算列表
   * step4：通知费用层进行数据结算
   * step5：根据结算信息更新陈列任务状态
   *
   * @param businessCode 陈列任务业务编码
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void handleSettlementTask(String businessCode) {
    DisplayCalculateTask displayCalculateTask = this.displayCalculateTaskRepository.findByBusinessCode(businessCode);
    Validate.notNull(displayCalculateTask, "业务单号：" + businessCode + "未获取到对应陈列任务！");
    Validate.isTrue(DisplayTaskStatusNewEnum.RUNNING.getDictCode().equals(displayCalculateTask.getTaskStatus()), "只有待执行的任务可以进行结算！");
    DisplayPolicy displayPolicy = displayPolicyService.findByTemplateCode(displayCalculateTask.getTemplateId());
    Validate.notNull(displayPolicy, "业务单号：" + businessCode + "未获取到对应陈列政策！");
    //验证协议是否在进行中
    LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
    loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
    loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
    loginUserAgreementDto.setAgreementCode(displayCalculateTask.getAgreementId());
    List<AgreementVo> agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
    Validate.isTrue(!CollectionUtils.isEmpty(agreementVos), "业务单号：" + businessCode + "未获取到对应的已生效协议！");
    //陈列任务结算
    List<DisplayTaskDetail> displayTaskDetails = buildTaskDetail(displayPolicy, displayCalculateTask);
    //通知费用层
    this.sendToCost(displayCalculateTask, displayTaskDetails);
    //更新陈列任务信息
    this.updateDisplayTask(displayCalculateTask, displayTaskDetails);
    //保存陈列结算详情
    if (!CollectionUtils.isEmpty(displayTaskDetails)) {
      this.displayTaskDetailRepository.saveBatch(displayTaskDetails);
    }
  }

  /**
   * 修改任务状态(人工审核)
   *
   * @param displayTaskDto 陈列任务DTO
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateTaskStatus(DisplayTaskDto displayTaskDto) {
    Validate.notNull(displayTaskDto, "提交任务审核时，传入数据不能为空！");
    Validate.notBlank(displayTaskDto.getBusinessCode());
    Validate.notBlank(displayTaskDto.getFinalAuditResult());
    DisplayTask displayTask = displayTaskRepository.findByBusinessCode(displayTaskDto.getBusinessCode());
    Validate.notNull(displayTask, "该任务不存在");
    displayTask.setFinalAuditResult(displayTaskDto.getFinalAuditResult());
    displayTask.setRemark(displayTaskDto.getRemark());
    if (AuditResultEnum.QUALIFIED.getDictCode().equals(displayTask.getFinalAuditResult())) {
      displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
    } else {
      displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_NOT_PASS.getDictCode());
    }
    displayTaskRepository.updateById(displayTask);
  }

  /**
   * 上传陈列任务图片
   *
   * @param displayTaskUploadInfoDto 陈列任务上传图片信息DTO
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void handleSubmitDisplayTask(DisplayTaskUploadInfoDto displayTaskUploadInfoDto) {
    Validate.notNull(displayTaskUploadInfoDto, "传入数据不能为空！");
    Validate.notBlank(displayTaskUploadInfoDto.getBusinessCode(), "传入业务单号不能为空！");
    Validate.isTrue(!CollectionUtils.isEmpty(displayTaskUploadInfoDto.getDisplayTaskUploads()), "上传图片不能为空！");
    DisplayTask displayTask = displayTaskRepository.findByBusinessCode(displayTaskUploadInfoDto.getBusinessCode());
    Validate.notNull(displayTask, "该任务不存在");
    //校验任务的图片上传情况
    List<DisplayTaskUpload> displayTaskUploads = this.displayTaskUploadRepository.findByBusinessCode(displayTask.getBusinessCode());
    Validate.isTrue(displayTaskUploads.size() < 2, "此任务已上传过2次图片，无法继续上传图片");
    //更新陈列任务上传信息
    displayTask.setUploadPictureNumber(displayTaskUploads.size() + 1);
    displayTask.setRemark(displayTaskUploadInfoDto.getRemark());
    Date now = new Date();
    //创建上传详情并保存
    DisplayTaskUpload displayTaskUpload = new DisplayTaskUpload();
    displayTaskUpload.setUploadNumber(displayTask.getUploadPictureNumber());
    displayTaskUpload.setRemark(displayTask.getRemark());
    displayTaskUpload.setBusinessCode(displayTask.getBusinessCode());
    displayTaskUpload.setPictureNumber(displayTaskUploadInfoDto.getDisplayTaskUploads().size());
    displayTaskUpload.setCreateTime(now);
    this.displayTaskUploadRepository.save(displayTaskUpload);
    //保存上传图片
    List<DisplayTaskUploadDetail> displayTaskUploadDetails = Lists.newArrayList();
    displayTaskUploadInfoDto.getDisplayTaskUploads().forEach(displayTaskUploadDto -> {
      DisplayTaskUploadDetail displayTaskUploadDetail = new DisplayTaskUploadDetail();
      displayTaskUploadDetail.setCreateTime(now);
      displayTaskUploadDetail.setBusinessCode(displayTask.getBusinessCode());
      displayTaskUploadDetail.setPictureUrl(displayTaskUploadDto.getPictureUrl());
      displayTaskUploadDetail.setUploadId(displayTaskUpload.getId());
      displayTaskUploadDetail.setPictureSerialNumber(displayTaskUploadDto.getPictureSerialNumber());
      displayTaskUploadDetails.add(displayTaskUploadDetail);
    });
    displayTaskRepository.updateById(displayTask);
    displayTaskUploadDetailRepository.saveBatch(displayTaskUploadDetails);
    if (!CollectionUtils.isEmpty(aiDisplayAuditStrategies)) {
      for (AIDisplayAuditStrategy auditStrategy : aiDisplayAuditStrategies) {
        auditStrategy.displayAudit(displayTaskUpload);
      }
    }
  }

  // 设置分离任务陈列次数
  @Transactional
  public void bindCalculateTaskRelateTask(List<DisplayCalculateTask> quantifyTasks,
      List<DisplayTask> taskList) {
    if(CollectionUtils.isEmpty(quantifyTasks) || CollectionUtils.isEmpty(taskList)) {
      return;
    }
    List<DisplayCalculateTaskRelateTask> list = Lists.newArrayList();
    for (DisplayCalculateTask item : quantifyTasks) {
      for (DisplayTask task : taskList) {
        if(this.validateTimeBetween(item, task)) {
          DisplayCalculateTaskRelateTask cur = new DisplayCalculateTaskRelateTask();
          cur.setCalculateTaskCode(item.getBusinessCode());
          cur.setTaskCode(task.getBusinessCode());
          list.add(cur);
        }
      }
    }
    if(CollectionUtils.isEmpty(list)){
      return;
    }
    this.displayCalculateTaskRelateTaskService.saveBatch(list);
  }

  /**
   * 批量改变任务状态(开启)
   *
   * @param startTime 任务开始时间
   */
  private void startDisplayTaskBatch(Date startTime) {
    if (startTime == null) {
      return;
    }
    DisplayTaskDto displayTaskDto = new DisplayTaskDto();
    displayTaskDto.setTaskStartTime(startTime);
    displayTaskDto.setTaskStatus(DisplayTaskStatusNewEnum.DEFAULT.getDictCode());
    //更新陈列任务状态
    List<DisplayTask> displayTasks = displayTaskRepository.findByConditions(displayTaskDto);
    if (!CollectionUtils.isEmpty(displayTasks)) {
      displayTasks.forEach(displayTask -> {
        displayTask.setTaskStatus(DisplayTaskStatusNewEnum.RUNNING.getDictCode());
      });
    }
    displayTaskRepository.updateBatchById(displayTasks);
    //更新陈列结算任务状态
    displayTaskDto.setTaskStatus(DisplayTaskStatusNewEnum.DEFAULT.getDictCode());
    List<DisplayCalculateTask> displayCalculateTasks = displayCalculateTaskRepository.findByConditions(displayTaskDto);
    if (!CollectionUtils.isEmpty(displayCalculateTasks)) {
      displayCalculateTasks.forEach(displayCalculateTask -> {
        displayCalculateTask.setTaskStatus(DisplayTaskStatusNewEnum.RUNNING.getDictCode());
      });
    }
    displayCalculateTaskRepository.updateBatchById(displayCalculateTasks);
  }

  /**
   * 批量改变任务状态(关闭)
   *
   * @param endTime 任务结束时间
   */
  @Transactional
  public void closeDisplayTaskBatch(Date endTime) {
    if (endTime == null) {
      return;
    }
    DisplayTaskDto displayTaskDto = new DisplayTaskDto();
    displayTaskDto.setTaskEndTime(endTime);
    displayTaskDto.setAuditStatusList(
      Lists.newArrayList(DisplayTaskAuditStatusNewEnum.DEFAULT.getDictCode(),
        DisplayTaskAuditStatusNewEnum.AI_DEFAULT.getDictCode(),
        DisplayTaskAuditStatusNewEnum.AI_REJECT.getDictCode(),
        DisplayTaskAuditStatusNewEnum.AUDIT_DEFAULT.getDictCode()
    ));
    List<DisplayTask> displayTasks = displayTaskRepository.findByConditions(displayTaskDto);
    if(CollectionUtils.isEmpty(displayTasks)) {
      return;
    }
    for (DisplayTask item : displayTasks) {
      if(DisplayTaskAuditStatusNewEnum.DEFAULT.getDictCode().equals(item.getAuditStatus()) ||
        DisplayTaskAuditStatusNewEnum.AI_DEFAULT.getDictCode().equals(item.getAuditStatus())) {
        item.setAuditStatus(DisplayTaskAuditStatusNewEnum.NO_SUBMIT.getDictCode());
        item.setTaskStatus(DisplayTaskStatusNewEnum.FAIL.getDictCode());
      }else if(DisplayTaskAuditStatusNewEnum.AUDIT_DEFAULT.getDictCode().equals(item.getAuditStatus()) ||
        DisplayTaskAuditStatusNewEnum.AI_REJECT.getDictCode().equals(item.getAuditStatus())) {
        item.setAuditStatus(DisplayTaskAuditStatusNewEnum.DEFAULT_PASS.getDictCode());
        item.setTaskStatus(DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
      }
    }
    displayTaskRepository.updateBatchById(displayTasks);
  }

  /**
   * 根据陈列政策和任务进行结算，构造任务结算明细列表
   * 获取所有陈列任务数量
   * 获取已完成陈列任务数据
   * 已绑定销量目标则计算是否已经达到销量目标
   * 根据达成率构造分利
   *
   * @param displayPolicy        陈列政策
   * @param displayCalculateTask 陈列任务
   * @return 任务结算明细列表
   */
  private List<DisplayTaskDetail> buildTaskDetail(DisplayPolicy displayPolicy, DisplayCalculateTask displayCalculateTask) {
    List<DisplayTaskDetail> displayTaskDetails = Lists.newArrayList();
    int allTaskNumber = this.displayTaskRepository.countByTaskTimeAndStatus(displayCalculateTask.getAgreementId(), displayCalculateTask.getTaskStartTime(), displayCalculateTask.getTaskEndTime(), null);
    int passTaskNumber = this.displayTaskRepository.countByTaskTimeAndStatus(displayCalculateTask.getAgreementId(), displayCalculateTask.getTaskStartTime(), displayCalculateTask.getTaskEndTime(), DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
    BigDecimal reachRate = allTaskNumber == 0 ? BigDecimal.ZERO : new BigDecimal(passTaskNumber).divide(new BigDecimal(allTaskNumber), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
    displayPolicy.getDisplayPolicyConfigurations().forEach(configuration -> {
      if (!displayCalculateTask.getDisplayPolicyConfigurationId().equals(configuration.getId())) {
        return;
      }
      BigDecimal scanCount = BigDecimal.ZERO;
      //绑定有销量的任务
      if (BindStatusEnum.YES.getDictCode().equals(displayPolicy.getBindSaleStatus())) {
        ScanCodeRecordPageDto scanCodeRecordPageDto = new ScanCodeRecordPageDto();
        scanCodeRecordPageDto.setCreateTimeStart(displayCalculateTask.getTaskStartTime());
        scanCodeRecordPageDto.setCreateTimeEnd(displayCalculateTask.getTaskEndTime());
        scanCodeRecordPageDto.setScanParticipatorCode(displayCalculateTask.getTerminalCode());
        scanCodeRecordPageDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        if (MaterialDimensionConstant.DIMENSION_ALL.equals(displayPolicy.getDimensionFlag())) {
          //如果商品标签是全部，则直接调用扫码模块获取该时间段内扫码数量
          scanCodeRecordPageDto.setProductCodes(Lists.newArrayList());
          scanCount = scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
        } else {
          //非全部商品，则通过产品维度获取物料编码集合，然后调用扫码模块获取扫码数量
          List<String> dimensionCodes = configuration.getDisplayPolicyRanges()
                  .stream().map(DisplayPolicyRange::getSpecialCode).collect(Collectors.toList());
          List<String> materialCodes = materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, displayPolicy.getDimensionFlag());
          if (!CollectionUtils.isEmpty(materialCodes)) {
            scanCodeRecordPageDto.setProductCodes(materialCodes);
            scanCount = scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
          }
        }
        if (scanCount.compareTo(displayCalculateTask.getSaleTarget()) < 0) {
          return;
        }
      }
      //根据分利标记选择对应的分利计算规则
      if (configuration.getOnlyHighestLevel().equals(AutoSignEnum.YES.getCode())) {
        displayTaskDetails.addAll(this.calculateWithOnlyHighestLevel(displayCalculateTask, scanCount, reachRate));
      } else {
        displayTaskDetails.addAll(this.calculateWithAllLevel(displayCalculateTask, scanCount, reachRate));
      }
    });
    return displayTaskDetails;
  }

  /**
   * 向消费层发布结算消息
   *
   * @param displayTask        陈列任务
   * @param displayTaskDetails 陈列结算信息列表
   */
  private void sendToCost(DisplayCalculateTask displayTask, List<DisplayTaskDetail> displayTaskDetails) {
    if (CollectionUtils.isEmpty(displayTaskDetails)) {
      return;
    }
    List<PolicyRewardConditionDto> policyRewardConditionDtos = Lists.newArrayList();
    displayTaskDetails.forEach(detail -> {
      if (AutoSignEnum.YES.getCode().equals(detail.getProfitStatus())) {
        //针对需要传递至费用层构造DTO
        PolicyRewardConditionDto policyRewardConditionDto = new PolicyRewardConditionDto();
        policyRewardConditionDto.setPolicyName(this.displayPolicyMountRegister.getName());
        //参与者信息
        policyRewardConditionDto.setActualParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
        policyRewardConditionDto.setActualParticipatorCode(displayTask.getTerminalCode());
        policyRewardConditionDto.setParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
        policyRewardConditionDto.setParticipatorName(ParticipatorTypeEnum.TERMINAL.getValue());
        policyRewardConditionDto.setTemplateCode(displayTask.getTemplateId());
        //奖励方式
        policyRewardConditionDto.setRewardMethodFlag(detail.getRewardMethodFlag());
        policyRewardConditionDto.setRewardMethodName(detail.getRewardMethodName());
        //奖励条件
        policyRewardConditionDto.setAwardConditionFlag(detail.getAwardConditionFlag());
        policyRewardConditionDto.setAwardConditionName(detail.getAwardConditionName());
        //奖励金额
        policyRewardConditionDto.setRewardData(detail.getRewardData().toString());
        //触发动作
        policyRewardConditionDto.setTriggerAction(this.displayPolicyMountRegister.getName());
        policyRewardConditionDto.setTriggerObject(displayTask.getBusinessCode());
        //协议编码
        policyRewardConditionDto.setAgreementCode(displayTask.getAgreementId());
        policyRewardConditionDto.setRebateType("陈列政策分利");
        policyRewardConditionDtos.add(policyRewardConditionDto);
      }
    });
    if (!CollectionUtils.isEmpty(policyRewardConditionDtos) && !CollectionUtils.isEmpty(policyRewardServiceObservers)) {
      //观察者和需要传递至费用层dto不为空时，进行结算传递
      policyRewardServiceObservers.forEach(policyRewardServiceObserver -> {
        policyRewardServiceObserver.createRewardRecord(policyRewardConditionDtos);
      });
    }
  }

  /**
   * 更新陈列任务状态
   *
   * @param displayTask        陈列任务
   * @param displayTaskDetails 陈列任务结算列表
   */
  @Transactional
  public void updateDisplayTask(DisplayCalculateTask displayTask, List<DisplayTaskDetail> displayTaskDetails) {
    if(Objects.isNull(displayTask)) {
      return;
    }
    displayTask.setTaskStatus(DisplayTaskStatusNewEnum.FAIL.getDictCode());
    if (!CollectionUtils.isEmpty(displayTaskDetails)) {
      Optional<DisplayTaskDetail> first = displayTaskDetails.stream()
          .filter(a -> "Y".equals(a.getProfitStatus())).findFirst();
      if(first.isPresent()) {
        displayTask.setTaskStatus(DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
      }
    }
    this.displayCalculateTaskRepository.updateById(displayTask);
  }

  /**
   * 根据陈列政策的结算类别寻找对应的组装实现类
   *
   * @param calculateCycle 结算类别(月/季/半年/年)
   * @return 陈列计算任务组装类
   */
  private DisplayCalculateTaskBuilder findBuilderByCalculateCycle(String calculateCycle) {
    DisplayCalculateTaskBuilder displayCalculateTaskBuilder = null;
    for (DisplayCalculateTaskBuilder t : displayCalculateTaskBuilders) {
      if (t.quantifyTaskCycle().equals(calculateCycle)) {
        displayCalculateTaskBuilder = t;
        break;
      }
    }
    return displayCalculateTaskBuilder;
  }

  /**
   * 创建陈列分利任务列表
   *
   * @param agreementVo   协议vo
   * @param configuration 陈列政策配置
   * @param displayPolicy 陈列协议配置
   * @return 陈列分利任务列表
   */
  private List<DisplayCalculateTask> buildDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicyConfiguration configuration, DisplayPolicy displayPolicy) {
    List<DisplayCalculateTask> displayCalculateTasks = Lists.newArrayList();
    //构造结算周期-结算表达式map
    Map<String, List<DisplayPolicyExpression>> displayExpressionMap = convertMapByCalculateCycle(configuration);
    if (displayExpressionMap.size() == 0) {
      return displayCalculateTasks;
    }
    //获取销量阶梯信息
    AgreementLadderVo agreementLadderVo = agreementLadderVoService.findByLadderCode(configuration.getAgreementLadderCode());
    if (Objects.isNull(agreementLadderVo)) {
      return displayCalculateTasks;
    }
    displayExpressionMap.forEach((key, value) -> {
      //获取陈列分利任务构造器
      DisplayCalculateTaskBuilder taskBuilder = this.findBuilderByCalculateCycle(key);
      if (Objects.isNull(taskBuilder)) {
        return;
      }
      //使用构造器构造陈列分利任务
      List<DisplayCalculateTask> quantifyTasks = taskBuilder.handleAssemblyDisplayCalculateTask(agreementVo, displayPolicy);
      if (CollectionUtils.isEmpty(quantifyTasks)) {
        return;
      }
      //调用编码生成接口，生成业务编码
      List<String> businessCodes = generateCodeService.generateCode(DisplayConstant.DISPLAY_TASK_CODE, quantifyTasks.size());
      Validate.isTrue(!CollectionUtils.isEmpty(businessCodes) && businessCodes.size() == quantifyTasks.size(), "生成业务单号异常");
      for (int i = 0; i < quantifyTasks.size(); i++) {
        //补充业务单号以及其他信息
        DisplayCalculateTask task = quantifyTasks.get(i);
        task.setBusinessCode(businessCodes.get(i));
        task.setDisplayPolicyId(configuration.getDisplayPolicyId());
        task.setTaskType(key);
        task.setAgreementId(agreementVo.getAgreementCode());
        task.setAgreementName(agreementVo.getAgreementName());
        task.setTemplateId(agreementVo.getTemplateCode());
        task.setTemplateName(agreementVo.getBelongTemplate());
        task.setTerminalCode(agreementVo.getTerminalCode());
        task.setTerminalName(agreementVo.getRelationTerminal());
        task.setTenantCode(TenantUtils.getTenantCode());
        task.setBindSaleStatus(displayPolicy.getBindSaleStatus());
        task.setDisplayPolicyConfigurationId(configuration.getId());
        task.setDisplayTaskExpressionList((List<DisplayTaskExpression>) nebulaToolkitService.copyCollectionByWhiteList(value, DisplayPolicyExpression.class, DisplayTaskExpression.class, HashSet.class, ArrayList.class));
        task.getDisplayTaskExpressionList().forEach(quantifyExpress -> {
          quantifyExpress.setBusinessCode(task.getBusinessCode());
          quantifyExpress.setId(null);
        });
        task.setDisplayType(displayPolicy.getDisplayType());
        task.setDisplayFinishTimes(BigDecimal.ZERO);
        task.setDisplayFinishRate(BigDecimal.ZERO);
        task.setSaleActual(BigDecimal.ZERO);
        task.setScanRate(BigDecimal.ZERO);
        task.setShareProfitStatus(DisplayConstant.ZERO);
        displayCalculateTasks.add(task);
      }
    });
    return displayCalculateTasks;
  }

  /**
   * 根据陈列政策配置，筛选不同结算周期对应的分利表达式
   *
   * @param displayPolicyConfiguration 陈列政策配置
   * @return 结算周期-分利表达式map
   */
  private Map<String, List<DisplayPolicyExpression>> convertMapByCalculateCycle(DisplayPolicyConfiguration displayPolicyConfiguration) {
    Map<String, List<DisplayPolicyExpression>> displayExpressionMap = Maps.newHashMap();
    displayPolicyConfiguration.getDisplayPolicyExpressions().forEach(displayPolicyExpression -> {
              List<DisplayPolicyExpression> expressions = displayExpressionMap.get(displayPolicyExpression.getCalculateCycle());
              if (CollectionUtils.isEmpty(expressions)) {
                expressions = Lists.newArrayList();
              }
              expressions.add(displayPolicyExpression);
              displayExpressionMap.put(displayPolicyExpression.getCalculateCycle(), expressions);
            }
    );
    return displayExpressionMap;
  }

  /**
   * 计算分利达成情况(只有最高级别可以分利)
   *
   * @param displayCalculateTask 陈列分利任务
   * @param scanCount            扫码数量
   * @param reachRate            任务达成率
   * @return 分利达成明细
   */
  private List<DisplayTaskDetail> calculateWithOnlyHighestLevel(DisplayCalculateTask displayCalculateTask, BigDecimal scanCount, BigDecimal reachRate) {
    List<DisplayTaskDetail> quantifyTaskDetails = Lists.newArrayList();
    if (CollectionUtils.isEmpty(displayCalculateTask.getDisplayTaskExpressionList())) {
      return quantifyTaskDetails;
    }
    //按照达成率倒序排列分利表达式
    displayCalculateTask.getDisplayTaskExpressionList().sort((o1, o2) -> o2.getReachRate().compareTo(o1.getReachRate()));
    //是否已经分利标记
    BigDecimal alreadyReachRate = null;
    for (DisplayTaskExpression expression : displayCalculateTask.getDisplayTaskExpressionList()) {
      DisplayTaskDetail taskDetail = nebulaToolkitService.copyObjectByWhiteList(expression, DisplayTaskDetail.class, Set.class, ArrayList.class);
      taskDetail.setId(null);
      taskDetail.setBusinessCode(displayCalculateTask.getBusinessCode());
      taskDetail.setSaleTarget(displayCalculateTask.getSaleTarget());
      taskDetail.setActualSales(scanCount);
      taskDetail.setReachRate(reachRate);
      if (!Objects.isNull(alreadyReachRate)) {
        //如果已经有分利表达式达标，则比较当前分利比例是否等于已分利比例，相等则可以进行分利，不相等不能进行分利
        if (alreadyReachRate.compareTo(expression.getReachRate()) == 0) {
          taskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
        } else {
          taskDetail.setProfitStatus(AutoSignEnum.NO.getCode());
        }
      } else {
        //如果没有分利表达式达标，根据达标比例设定结算明细的分利状态
        taskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
        //更新达标标记
        alreadyReachRate = taskDetail.getProfitStatus().equals(AutoSignEnum.YES.getCode()) ? expression.getReachRate() : null;
      }
      quantifyTaskDetails.add(taskDetail);
    }
    return quantifyTaskDetails;
  }

  /**
   * 计算分利达成情况(所以级别都可以分利)
   *
   * @param displayCalculateTask 陈列分利任务
   * @param scanCount            扫码数量
   * @param reachRate            任务达成率
   * @return 分利达成明细
   */
  private List<DisplayTaskDetail> calculateWithAllLevel(DisplayCalculateTask displayCalculateTask, BigDecimal scanCount, BigDecimal reachRate) {
    List<DisplayTaskDetail> quantifyTaskDetails = Lists.newArrayList();
    if (CollectionUtils.isEmpty(displayCalculateTask.getDisplayTaskExpressionList())) {
      return quantifyTaskDetails;
    }
    //按照达成率倒序排列分利表达式
    displayCalculateTask.getDisplayTaskExpressionList().sort((o1, o2) -> o2.getReachRate().compareTo(o1.getReachRate()));
    //是否已经分利标记
    for (DisplayTaskExpression expression : displayCalculateTask.getDisplayTaskExpressionList()) {
      DisplayTaskDetail taskDetail = nebulaToolkitService.copyObjectByWhiteList(expression, DisplayTaskDetail.class, Set.class, ArrayList.class);
      taskDetail.setId(null);
      taskDetail.setBusinessCode(displayCalculateTask.getBusinessCode());
      taskDetail.setSaleTarget(displayCalculateTask.getSaleTarget());
      taskDetail.setActualSales(scanCount);
      taskDetail.setReachRate(reachRate);
      taskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
      quantifyTaskDetails.add(taskDetail);
    }
    return quantifyTaskDetails;
  }



  // 验证task是否是在分利任务执行范围内
  private Boolean validateTimeBetween(DisplayCalculateTask calculateTask, DisplayTask task) {
    Boolean f = Objects.isNull(calculateTask.getTaskStartTime())
                  || Objects.isNull(calculateTask.getTaskEndTime())
                  || Objects.isNull(task.getTaskStartTime())
                  || Objects.isNull(task.getTaskEndTime());
    if(f) {
      return false;
    }
    return calculateTask.getTaskStartTime().compareTo(task.getTaskStartTime()) <= 0
        && calculateTask.getTaskEndTime().compareTo(task.getTaskEndTime()) >= 0;
  }
}
