package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadAudit;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadAuditRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskUploadAuditService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 陈列上传审核接口实现
 *
 * @author sunx
 * @date 2021/12/17
 */
@Service
public class DisplayTaskUploadAuditServiceImpl implements DisplayTaskUploadAuditService {

  @Autowired private DisplayTaskUploadAuditRepository displayTaskUploadAuditRepository;

  @Autowired private LoginUserService loginUserService;

  @Override
  @Transactional
  public void create(DisplayTaskUploadAudit audit) {
    Validate.notNull(audit, "参数不能为空!");
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未获取到登录人信息");
    audit.setCreateTime(new Date());
    audit.setCreateAccount(loginUser.getAccount());
    this.displayTaskUploadAuditRepository.save(audit);
  }

  @Override
  public List<DisplayTaskUploadAudit> findByDisplayTaskUploadIds(
      List<String> displayTaskUploadIdList) {
    if (CollectionUtils.isEmpty(displayTaskUploadIdList)) {
      return Lists.newLinkedList();
    }
    return this.displayTaskUploadAuditRepository.findByDisplayTaskUploadIds(
        displayTaskUploadIdList);
  }
}
