package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayConfigurationVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskUploadDetailVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskUploadVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.TerminalBaseVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyConfiguration;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyConfigurationRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskVoService;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author HuaHongQiang
 * @date 2021/8/27 14:09
 * 陈列任务接口实现
 */
@Service
public class DisplayTaskVoServiceImpl implements DisplayTaskVoService {

  @Autowired
  private DisplayTaskRepository displayTaskRepository;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private DisplayPolicyConfigurationRepository displayPolicyConfigurationRepository;

  @Autowired
  private DisplayPolicyRepository displayPolicyRepository;

  @Autowired
  private DisplayTaskUploadRepository uploadRepository;

  @Autowired(required = false)
  private TerminalMdmService terminalMdmService;

  @Autowired
  private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;

  @Autowired
  private LoginUserService loginUserService;


  /**
   * 根据业务单号查询陈列任务
   * step1:查询陈列政策配置
   * step2:查询上传图片
   * step3:查询终端基本信息
   * step4:组装陈列示意图片
   * @param businessCode 业务单号
   * @return 陈列任务Vo
   */
  @Override
  public DisplayTaskVo findByBusinessCode(String businessCode) {
    if (StringUtils.isBlank(businessCode)){
      return null;
    }
    DisplayTask displayTask = displayTaskRepository.findByBusinessCode(businessCode);
    DisplayTaskVo displayTaskVo = nebulaToolkitService
        .copyObjectByWhiteList(displayTask, DisplayTaskVo.class, HashSet.class, ArrayList.class);
    //查询陈列政策配置
    List<DisplayPolicyConfiguration> configurations = displayPolicyConfigurationRepository
        .findByDisplayPolicyId(displayTask.getDisplayPolicyId());
    Collection<DisplayConfigurationVo> configurationVos = nebulaToolkitService
        .copyCollectionByWhiteList(configurations, DisplayPolicyConfiguration.class,DisplayConfigurationVo.class, HashSet.class, ArrayList.class, "displayPolicyRanges", "displayPolicyExpressions");
    Set<DisplayConfigurationVo> configurationVoSet = new HashSet<>(configurationVos);
    DisplayPolicy displayPolicy = displayPolicyRepository.findById(displayTask.getDisplayPolicyId());
    //查询上传图片
    List<DisplayTaskUpload> taskUploads = uploadRepository.findByBusinessCode(displayTask.getBusinessCode());
    Collection<DisplayTaskUploadVo> displayTaskUploadVos = nebulaToolkitService
        .copyCollectionByWhiteList(taskUploads, DisplayTaskUpload.class, DisplayTaskUploadVo.class, HashSet.class, ArrayList.class);
    Set<DisplayTaskUploadVo> displayTaskUploadVoSet = new HashSet<>(displayTaskUploadVos);
    //查询终端基本信息
    Set<String> codes = Sets.newHashSet(displayTask.getTerminalCode());
    List<TerminalMdmVo> detailByCodes = terminalMdmService.findDetailByCodes(codes);
    TerminalBaseVo terminalBaseVo = new TerminalBaseVo();
    if (!CollectionUtils.isEmpty(detailByCodes)){
      terminalBaseVo = nebulaToolkitService
          .copyObjectByWhiteList(detailByCodes.get(0), TerminalBaseVo.class, HashSet.class,
              ArrayList.class);
    }
    //组装陈列示例图片
    List<DisplayTaskUploadDetail> SampleGraphs = this.displayTaskUploadDetailRepository
        .findByBusinessCode(displayPolicy.getId());
    if (!CollectionUtils.isEmpty(SampleGraphs)){
     Collection<DisplayTaskUploadDetailVo> displaySampleGraphVos = this.nebulaToolkitService
              .copyCollectionByWhiteList(SampleGraphs, DisplayTaskUploadDetail.class,
                      DisplayTaskUploadDetailVo.class, HashSet.class, ArrayList.class);
      displayTaskVo.setDisplaySampleGraphs(new HashSet<>(displaySampleGraphVos));
    }
    //组装数据
    displayTaskVo.setDisplayConfigurations(configurationVoSet);
    displayTaskVo.setDisplayType(displayPolicy.getDisplayType());
    displayTaskVo.setDisplayTaskUploads(displayTaskUploadVoSet);
    displayTaskVo.setTerminalBaseVo(terminalBaseVo);
    return displayTaskVo;
  }

  /**
   * 根据终端编码查询陈列任务
   * @param taskStatus 任务状态
   * @return 陈列任务Vo
   */
  @Override
  public List<DisplayTaskVo> findByTerminalCode(String taskStatus) {
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser,"获取当前登录用户信息失败");
    String terminalCode = loginUser.getConsumerCode();
    if (StringUtils.isBlank(terminalCode)){
      return null;
    }
    List<DisplayTask> displayTasks = displayTaskRepository.findByTerminalCode(terminalCode,taskStatus);
    if (CollectionUtils.isEmpty(displayTasks)){
      return null;
    }
    //装配数据
    return new ArrayList<>(nebulaToolkitService
            .copyCollectionByWhiteList(displayTasks, DisplayTask.class, DisplayTaskVo.class,
                    HashSet.class, ArrayList.class));
  }

  /**
   * 根据业务单号查询陈列任务上传照片
   * @param businessCode 业务单号
   * @return 陈列任务Vo
   */
  @Override
  public DisplayTaskVo findPictureByBusinessCode(String businessCode) {
    if(StringUtils.isBlank(businessCode)){
      return null;
    }
    DisplayTask displayTask = displayTaskRepository.findByBusinessCode(businessCode);
    List<DisplayTaskUpload> uploads = uploadRepository.findByBusinessCode(businessCode);
    if (CollectionUtils.isEmpty(uploads) || displayTask == null){
      return null;
    }
    //装配数据
    Set<DisplayTaskUploadVo> displayTaskUploadVos = new HashSet<>(nebulaToolkitService
            .copyCollectionByWhiteList(uploads, DisplayTaskUpload.class,
                    DisplayTaskUploadVo.class, HashSet.class, ArrayList.class,"displayTaskUploadDetails"));
    DisplayTaskVo displayTaskVo = new DisplayTaskVo();
    displayTaskVo.setDisplayTaskUploads(displayTaskUploadVos);
    displayTaskVo.setAiAuditResult(displayTask.getAiAuditResult());
    return displayTaskVo;
  }

}
