package com.biz.crm.cps.business.policy.display.ladder.local.service.notifier;

import cn.hutool.json.JSONUtil;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayCalculateTaskService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 陈列任务实现扫码事件处理
 *
 * @author sunx
 * @date 2021/12/16
 */
@Component
@Slf4j
public class DisplayTaskEventListenerImpl implements ScanCodeRecordEventListener {

  @Autowired private DisplayCalculateTaskService displayCalculateTaskService;

  @Override
  public void onSuccessScan(ScanCodeRecordEventDto dto) {
    log.info("财年包量政策扫码事件实现处理[{}]", JSONUtil.toJsonStr(dto));
    if (Objects.isNull(dto)
        || StringUtils.isBlank(dto.getBarCode())
        || StringUtils.isBlank(dto.getProductCode())) {
      return;
    }
    this.displayCalculateTaskService.updateScanInfoByProductCodeAndBarCode(dto.getProductCode(), dto.getBarCode());
  }

  @Override
  public void onFailScan(ScanCodeRecordEventDto dto) {}

}
