package com.biz.crm.cps.business.policy.display.ladder.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyMountRegister;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyPojoObserver;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * 陈列政策，用来处理协议模板与政策之间的对象转换
 * @author HuaHongQiang
 */
@Component("DisplayPolicyPojoObserverImpl")
public class DisplayPolicyPojoObserverImpl implements AgreementPolicyPojoObserver {

  @Autowired
  @Qualifier("DisplayPolicyMountRegisterImpl")
  private AgreementPolicyMountRegister agreementPolicyMountRegister;

  @Override
  public DisplayPolicyDto deserialize(JSONObject jsonObject) {
    /**
     * 把字符串转json对象
     * 获取跟陈列政策相关的信息
     * 将信息拷贝到对象中
     */
    if (Objects.isNull(jsonObject)) {
      return null;
    }
    return JsonUtils.json2Obj(jsonObject.toJSONString(), DisplayPolicyDto.class);
  }

  @Override
  public JSONObject serialize(AgreementPolicyDto agreementPolicyDto) {
    return null;
  }
}
