package com.biz.crm.cps.business.policy.display.ladder.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayPolicyUploadRuleVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.PolicyObserverDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 陈列政策，提供协议模板要求政策提供的API
 *
 * @author HuaHongQiang
 */
@Component("DisplayPolicyServiceObserverImpl")
public class DisplayPolicyServiceObserverImpl implements AgreementPolicyServiceObserver {

  @Autowired
  private DisplayPolicyService displayPolicyService;

  @Autowired
  private DisplayPolicyPojoObserverImpl displayPolicyPojoObserver;

  @Autowired
  private DisplayPolicyMountRegisterImpl displayPolicyMountRegister;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 保存陈列政策信息到数据库
   *
   * @param agreementPolicyDto
   */
  @Override
  public void onCreate(AgreementPolicyDto agreementPolicyDto) {
    this.displayPolicyService.create(agreementPolicyDto);
  }

  @Override
  public AgreementPolicyVo onFindDetailsByTemplateCode(String templateCode) {
    DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(templateCode);
    if (ObjectUtils.isEmpty(displayPolicy)) {
      return null;
    }
    DisplayPolicyVo displayPolicyVo = nebulaToolkitService.copyObjectByWhiteList(displayPolicy, DisplayPolicyVo.class, HashSet.class, ArrayList.class,
        "saleTarget","uploadRules","displayPolicyConfigurations", "displayPolicyConfigurations.displayPolicyRanges", "displayPolicyConfigurations.displayPolicyExpressions","displaySampleGraphs");
    displayPolicyVo.setPolicyKey(this.displayPolicyMountRegister.getKey());
    displayPolicyVo.setTemplateCode(templateCode);
    if (!CollectionUtils.isEmpty(displayPolicyVo.getUploadRules())){
      List<DisplayPolicyUploadRuleVo> uploadRuleVos = displayPolicyVo.getUploadRules().stream()
          .sorted(Comparator.comparing(
              DisplayPolicyUploadRuleVo::getOrderNum)).collect(Collectors.toList());
      displayPolicyVo.setUploadRules(uploadRuleVos);
    }
    return displayPolicyVo;
  }

  @Override
  public void onProcessScanCode(PolicyObserverDto policyObserverDto) {
    AgreementPolicyServiceObserver.super.onProcessScanCode(policyObserverDto);
  }

  @Override
  public void onCreate(JSONObject jsonObject) {
    if (ObjectUtils.isEmpty(jsonObject)) {
      return;
    }
    JSONObject policy = jsonObject.getJSONObject(this.displayPolicyMountRegister.getKey());
    AgreementPolicyDto deserialize = this.displayPolicyPojoObserver.deserialize(policy);
    if (deserialize == null){
      return;
    }
    deserialize.setTemplateCode(jsonObject.getString("templateCode"));
    //政策验重
    AgreementTemplateVo agreementTemplateVo = JsonUtils.json2Obj(jsonObject.getString("profitAgreementTemplate"), AgreementTemplateVo.class);
    this.displayPolicyService.validatePolicyScope(agreementTemplateVo, deserialize);
    this.onCreate(deserialize);
  }

  @Override
  public List<PolicyRewardDataVo> onFindPolicyRewardData(Set<String> templateCodeSet, String usertype) {
    return null;
  }

  /**
   * 修改陈列政策
   * @param jsonObject
   */
  @Override
  public void onChange(JSONObject jsonObject) {
    if (ObjectUtils.isEmpty(jsonObject)) {
      return;
    }
    JSONObject policy = jsonObject.getJSONObject(this.displayPolicyMountRegister.getKey());
    AgreementPolicyDto deserialize = this.displayPolicyPojoObserver.deserialize(policy);
    if (deserialize == null){
      return;
    }
    deserialize.setTemplateCode(jsonObject.getString("templateCode"));
    //政策验重
    AgreementTemplateVo agreementTemplateVo = JsonUtils.json2Obj(jsonObject.getString("profitAgreementTemplate"), AgreementTemplateVo.class);
    this.displayPolicyService.validatePolicyScope(agreementTemplateVo, deserialize);
    //获取当前时间是否在模板签署开始时间之前，true则可进行全部覆盖，
    Boolean before = jsonObject.getBoolean("before");
    this.displayPolicyService.update(deserialize, before);
  }
}
