package com.biz.crm.cps.business.policy.display.ladder.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignEventDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignObserver;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 陈列政策，当协议签署时实现包量任务创建
 *
 * @author hefan
 */
@Component("displayPolicySignObserverImpl")
public class DisplayPolicySignObserverImpl implements AgreementSignObserver {

  @Autowired
  private DisplayTaskService displayTaskService;
  @Autowired
  private DisplayPolicyService displayPolicyService;

  @Override
  public void onSuccess(AgreementSignEventDto dto) {
    DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(dto.getTemplateCode());
    if(Objects.nonNull(displayPolicy)){
      displayTaskService.create(dto.getAgreementCode());
    }
  }
}
