package com.biz.crm.cps.business.policy.display.ladder.local.service.strategy;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.AuditResultEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskAuditStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskUploadAuditTypeEnum;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadAudit;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskUploadAuditService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * @author jerry7
 * @date 2021/10/18 10:36 默认的ai图片审核实现
 */
@Component
public class DefaultAIDisplayAuditStrategyImpl implements AIDisplayAuditStrategy {

  @Autowired private DisplayTaskRepository displayTaskRepository;

  @Autowired private DisplayTaskUploadRepository displayTaskUploadRepository;

  @Autowired private DisplayTaskUploadAuditService displayTaskUploadAuditService;

  @Autowired private LoginUserService loginUserService;

  @Override
  @Transactional
  public void displayAudit(DisplayTaskUpload displayTaskUpload) {
    if (displayTaskUpload == null) {
      return;
    }
    DisplayTask displayTask =
        this.displayTaskRepository.findByBusinessCode(displayTaskUpload.getBusinessCode());
    if (!ObjectUtils.allNotNull(displayTask)) {
      return;
    }

    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未获取到用户信息");

    // 生成随机数1-100
    int max = 100, min = 1;
    int rand = (int) (Math.random() * (max - min) + min);
    int k = rand % 10;

    DisplayTaskUploadAudit audit = new DisplayTaskUploadAudit();
    audit.setDisplayTaskUploadId(displayTaskUpload.getId());
    audit.setDisplayAuditType(DisplayTaskUploadAuditTypeEnum.AI.getDictCode());
    audit.setCreateTime(new Date());
    audit.setCreateAccount(loginUser.getAccount());
    audit.setTenantCode(TenantUtils.getTenantCode());

    if (k >= 8) {
      displayTask.setAiAuditResult(AuditResultEnum.QUALIFIED.getDictCode());
      displayTask.setTaskStatus(DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
      displayTask.setAuditStatus(DisplayTaskAuditStatusNewEnum.AI_PASS.getDictCode());
      displayTaskUpload.setAiAuditResult(AuditResultEnum.QUALIFIED.getDictCode());
      audit.setAuditStatus(DisplayTaskAuditStatusNewEnum.AI_PASS.getDictCode());
      // 第二次驳回
    } else if (DisplayTaskAuditStatusNewEnum.AI_REJECT
        .getDictCode()
        .equals(displayTask.getAuditStatus())) {
      displayTask.setAiAuditResult(AuditResultEnum.UNQUALIFIED.getDictCode());
      displayTask.setTaskStatus(DisplayTaskStatusNewEnum.RUNNING.getDictCode());
      displayTask.setAuditStatus(DisplayTaskAuditStatusNewEnum.AUDIT_DEFAULT.getDictCode());
      displayTask.setRejectTime(new Date());
      displayTaskUpload.setAiAuditResult(AuditResultEnum.UNQUALIFIED.getDictCode());
      audit.setAuditStatus(DisplayTaskAuditStatusNewEnum.AUDIT_DEFAULT.getDictCode());
      // 第一次驳回
    } else {
      displayTask.setAiAuditResult(AuditResultEnum.UNQUALIFIED.getDictCode());
      displayTask.setTaskStatus(DisplayTaskStatusNewEnum.RUNNING.getDictCode());
      displayTask.setAuditStatus(DisplayTaskAuditStatusNewEnum.AI_REJECT.getDictCode());
      displayTask.setRejectTime(new Date());
      displayTaskUpload.setAiAuditResult(AuditResultEnum.UNQUALIFIED.getDictCode());
      audit.setAuditStatus(DisplayTaskAuditStatusNewEnum.AI_REJECT.getDictCode());
    }
    // 保存修改
    displayTaskRepository.updateById(displayTask);
    displayTaskUploadRepository.updateById(displayTaskUpload);
    this.displayTaskUploadAuditService.create(audit);
  }
}
