package com.biz.crm.cps.business.policy.display.ladder.local.utils;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicySaleTarget;
import org.apache.commons.lang3.time.DateUtils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

/**
 * @author HuaHongQiang
 * @date 2021/8/31 14:40
 * 陈列任务工具类
 */
public class DisplayPolicyUtils {

  /**
   * 根据当前月份返回设定的对应月份设定的销量目标
   *
   * @param month          当前月份
   * @param saleTarget 销量目标
   * @return 销量目标
   */
  public static BigDecimal getScaleByMonth(int month, DisplayPolicySaleTarget saleTarget) {
    switch (month) {
      case 1:
        return saleTarget.getJanuarySaleNum();
      case 2:
        return saleTarget.getFebruarySaleNum();
      case 3:
        return saleTarget.getMarchSaleNum();
      case 4:
        return saleTarget.getAprilSaleNum();
      case 5:
        return saleTarget.getMaySaleNum();
      case 6:
        return saleTarget.getJuneSaleNum();
      case 7:
        return saleTarget.getJulySaleNum();
      case 8:
        return saleTarget.getAugustSaleNum();
      case 9:
        return saleTarget.getSeptemberSaleNum();
      case 10:
        return saleTarget.getOctoberSaleNum();
      case 11:
        return saleTarget.getNovemberSaleNum();
      case 12:
      default:
        //默认返回12月份销量
        return saleTarget.getDecemberSaleNum();
    }
  }

  /**
   * 根据时间范围获取销量目标，获取时间段内每个月的销量目标进行累加
   *
   * @param startTime         开始时间
   * @param endTime           结束时间
   * @param saleTarget 绑定销量VO
   * @return 销量目标
   */
  public static BigDecimal getScaleByTimeInterval(Date startTime, Date endTime,  DisplayPolicySaleTarget saleTarget) {
    BigDecimal target = BigDecimal.ZERO;
    while (startTime.before(endTime)) {
      target = target.add(getScaleByMonth(startTime.getMonth() + 1, saleTarget));
      startTime = DateUtils.ceiling(startTime, Calendar.MONTH);
    }
    return target;
  }

}
